/*
 * The Truck class, renders truck and contains truck behavior and logic
 */

#ifndef TRUCK_H_
#define TRUCK_H_

#include "GameObject.h"
#include "GameWorld.h"
#include "Mesh.h"
#include "Gravel.h"

#include <iostream>
#include <fstream>
using std::ofstream;

/* Truck rendering and behavior, just a box for now */


class Truck: public GameObject {

  public:
    /* construct with reference to game world */
    Truck(GameWorld& gw);
    
    /* updates truck location  */
    void update(Uint32 timeElapsed);


    /* draw a truck at current location */
    virtual void draw();

    void CheckSlide();

    /* special collison detection for truck */
    bool willCollide(Vec3f truckLoc, Vec3f objLoc, GameObjPtr obj);
    
    /* get list of BV locations for cd */
    std::vector<Vec3f> getBVLocs(Vec3f truckLoc);
    
    /* set the angle of truck, only if no collisions */
    virtual void setAngleY(GLfloat v);
        
    /* set the acceleration of this object to point at angleY */
    void accelerate(GLfloat mag);
    
    /* set whether the truck is driving forward */
    void setDrivingForward(bool v) { drivingForward = v; }
    
    /* get whether the truck is driving forward */
    bool getDrivingForward() { return drivingForward; }
    

private: 
    /* mesh for truck */
    Mesh * object;
    
    /* gravel */
    Gravel * grav_right, * grav_left;
    
    /* scale of truck */
    GLfloat scale;
    
    /* truck radius for cd */
    GLfloat truckR;

    /* whether truck is driving forward */
    bool drivingForward;
    

};

#endif /*TRUCK_H_*/
 
