/*
 * Class that represents the initial title screen
 */
 
#ifndef TITLE_SCREEN_H_
#define TITLE_SCREEN_H_

#include <SDL.h>
#include <SDL_mixer.h>
#include <SDL_ttf.h>

enum TitleScreenMode { START_MODE, HOW_TO_MODE, QUIT_MODE, BACK_MODE, NO_MODE };

// helper function to increment modes
inline TitleScreenMode& operator++(TitleScreenMode& m) {
    m = TitleScreenMode(m + 1);
    return m;
}

// helper function to decrement modes
inline TitleScreenMode& operator--(TitleScreenMode& m) {
    m = TitleScreenMode(m - 1);
    return m;
}

/*
 * Class that sets up the title screen and audio
 */
class TitleScreen {
  public:
    /* default constructor */
    TitleScreen();
    
    /* destructor */
    ~TitleScreen();
    
    /* clear screen to black */
    void clearScreen();
    
    /* draw initial loading screen and play audio */
    void drawLoadingScreen();
    
    /* draw the current screen */
    void drawCurrentScreen();
    
    /* draw start selection screen */
    void drawStartScreen();
    
    /* draw how to play selection screen */
    void drawHowToScreen();
    
    /* draw quit selection screen */
    void drawQuitScreen();
    
    /* draw directions/how to screen */
    void drawDirectionsScreen();
    
    /* handle title screen events */
    void handleEvents();
    
    /* title screen music chunk */
    Mix_Chunk* getMusic() { return music; }
    
    /* start sound chunk */
    Mix_Chunk* getStartSound() { return startSound; }
    
    /* main music channel */
    int getMusicChannel() { return musicChannel; }
    
    /* start sound channel */
    int getStartSoundChannel() { return startSoundChannel; }
    
    TitleScreenMode getCurrentMode() { return currentMode; }
    
  private:
    bool startGame;
    
    /* title screen music chunk */
    Mix_Chunk* music;
    
    /* start sound chunk */
    Mix_Chunk* startSound;
    
    /* main music channel */
    int musicChannel;
    
    /* start sound channel */
    int startSoundChannel;
    
    TitleScreenMode currentMode;
    
    /* title screen surfaces */
    SDL_Surface* loadingScreen;
    SDL_Surface* startScreen;
    SDL_Surface* howToScreen;
    SDL_Surface* quitScreen;
    SDL_Surface* directionsScreen;
    
    /* handle a keyboard event */
    void handleKeyboardEvent(SDL_Event& event);
};

#endif /*TITLE_SCREEN_H_*/
