/*
 * surface utilities
 */
#ifndef SURFACE_UTIL_H_
#define SURFACE_UTIL_H_

#include <SDL_opengl.h>
#include <SDL.h>
#include <SDL_ttf.h>

/*
 * Class that provides helper functions for surface manipulation.
 */
class SurfaceUtil {
  public:
    /* SDL_Surface RGBA masks */
    static Uint32 R_MASK;
    static Uint32 G_MASK;
    static Uint32 B_MASK;
    static Uint32 A_MASK;
    
    /* SDL_Surface with RGBA format */
    static SDL_Surface* RGBA_SURFACE;

    /* initialize text utilities */
    static void init();

    /* reverses a surface in Y direction */
    static void reverseY(SDL_Surface* surface);
};

#endif /*SURFACE_UTIL_H_*/
