/*
 * surface utilities
 */
#include <iostream>
#include <algorithm>
#include <string>

#include <SDL.h>
#include <SDL_ttf.h>

#include "SurfaceUtil.h"
#include "Display.h"

using namespace std;

/* initialize surface utilities */
void SurfaceUtil::init() {
    if (SDL_BYTEORDER == SDL_BIG_ENDIAN) {
        R_MASK = 0xff000000;
        G_MASK = 0x00ff0000;
        B_MASK = 0x0000ff00;
        A_MASK = 0x000000ff;
    } else {
        R_MASK = 0x000000ff;
        G_MASK = 0x0000ff00;
        B_MASK = 0x00ff0000;
        A_MASK = 0xff000000;
    }
    RGBA_SURFACE = SDL_CreateRGBSurface(SDL_SWSURFACE, 1, 1, 32, R_MASK, G_MASK, B_MASK, A_MASK);
    if (RGBA_SURFACE == NULL) {
        cout << "Create TextUtil RGBA_SURFACE Failed!" << SDL_GetError() << endl;
    }
}

/* reverses a surface in Y direction */
void SurfaceUtil::reverseY(SDL_Surface* surface) {
    int bytes = surface->format->BytesPerPixel;
    unsigned char* origPixels = (unsigned char*)surface->pixels;
    unsigned char* reversed = new unsigned char[surface->w * bytes];
    for (int i = 0; i < (surface->h / 2); i++) {
        // save top row
        copy(&origPixels[i * surface->pitch],
             &origPixels[(i * surface->pitch) + surface->w * bytes],
             reversed);
        // copy bottom to top
        int bot = surface->h - i - 1;
        copy(&origPixels[bot * surface->pitch],
             &origPixels[(bot * surface->pitch) + surface->w * bytes], 
             &origPixels[i * surface->pitch]);
        // copy top to bottom
        copy(reversed,
             &reversed[surface->w * bytes],
             &origPixels[bot * surface->pitch]);
    }
}

/* storage definitions for static vars */
SDL_Surface* SurfaceUtil::RGBA_SURFACE;
Uint32 SurfaceUtil::R_MASK;
Uint32 SurfaceUtil::G_MASK;
Uint32 SurfaceUtil::B_MASK;
Uint32 SurfaceUtil::A_MASK;
