/*Smoke.cpp*/

#include "Smoke.h"
#include <iostream>
#include <time.h>
#include <cmath>

#include <fstream>

using namespace std;

//constructor
Smoke::Smoke()
{
	n_forces=1;
	f[0].setX(0);
	f[0].setY(0);
	vel.setX(.5);
	vel.setY(.5);
	
	c[0] = 0.0;
	c[1] = 0.0;
	c[2] = 0.0;      

	scale = 0.5;
	
	OutFile1.open("loggensmoke.txt", ios::out);
      
};

void Smoke::In()
{
     Init(80, n_forces, f, Update, vel, init_pos, 100, c, 80);
}

//load the texture for the gravel
void Smoke::Load()
{
    // SDL surface
    SDL_Surface* surface = SDL_LoadBMP("imgs/dirt.bmp");
    
    // generate texture
    glGenTextures(1, &texture);
    glBindTexture(GL_TEXTURE_2D, texture);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
    gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, surface->w, surface->h,
              GL_BGR, GL_UNSIGNED_BYTE, surface->pixels);
    
    // free surface
    SDL_FreeSurface(surface);
}     

   
/* check if all particle have died */
bool Smoke::allParticlesDead() {
    for(int i=0; i < particleNum; i++) {
        if(Particles[i].age >= 0) {
            return false;
        }
    }
    return true;
}

//draw the particlesystem
void Smoke::Render()
{
  all_drawn = false;
  //initialize rand
  srand (time(NULL));
		
  for(int i=0; i < particleNum; i++)
  {
     if(Particles[i].age >= 0) //only draw if they are "alive"
     {
        OutFile1 << "Pos[0]: " << Particles[0].Pos.getX() << " " << Particles[0].Pos.getY() << " " << Particles[0].Pos.getZ() << endl;
        OutFile1 << "Pos[1]: " << Particles[1].Pos.getX() << " " << Particles[1].Pos.getY() << " " << Particles[1].Pos.getZ() << endl;
        OutFile1 << "Pos[2]: " << Particles[2].Pos.getX() << " " << Particles[2].Pos.getY() << " " << Particles[2].Pos.getZ() << endl;
        
        
		glPushMatrix();
                   
        //set a random color, close to black
		//glColor3f(rand()%(100)/100.0, rand()%(100)/100.0, rand()%(100)/100.0);
            glDisable(GL_LIGHTING);
            
		glColor4f(0, 0, 0, .2);
		
        //set material to white
		//GLfloat white[] = { 1.0, 1.0, 1.0, 1.0 };
        ///	glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, white);
		
		//scale the gravel down to a fixed size
        GLfloat sc = 0.05;
		glScalef(sc, sc, sc);

		//scale the gravel randomly from this size
		//glScalef( rand()%(100)/100.0, rand()%(100)/100.0, rand()%(100)/100.0 );

		//if too old make even smaller
		if(Particles[i].age >= 10)
		{
            //glScalef(sc, sc, sc);
		  glScalef(scale,scale,scale);
		}

		glTranslatef(Particles[i].Pos.getX(), Particles[i].Pos.getY(), Particles[i].Pos.getZ());

                //draw a cube as a gravel
		OutFile1 << "Drawing cube nr: " <<  i << " at x: " << Particles[i].Pos.getX() << " y: " << Particles[i].Pos.getY() << " z: " << Particles[i].Pos.getZ() << endl;
	
		glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        //glBlendFunc(GL_SRC_ALPHA, GL_ONE); //GL_ONE_MINUS_SRC_ALPHA); 
		
 	    //glEnable(GL_TEXTURE_2D);
     	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
     	//glBindTexture(GL_TEXTURE_2D, texture);
     	glBegin(GL_QUADS);
       
		//glTexCoord2f(0.0, 0.0);
		glVertex3f( 1.0f, 1.0f,-1.0f);	
		//glTexCoord2f(1.0, 0.0);		
		glVertex3f(-1.0f, 1.0f,-1.0f);	
		//glTexCoord2f(1.0, 1.0);		
		glVertex3f(-1.0f, 1.0f, 1.0f);
		//glTexCoord2f(0.0, 1.0);			
		glVertex3f( 1.0f, 1.0f, 1.0f);			

		//glTexCoord2f(0.0, 0.0);
		glVertex3f( 1.0f,-1.0f, 1.0f);	
		//glTexCoord2f(1.0, 0.0);			
		glVertex3f(-1.0f,-1.0f, 1.0f);	
		//glTexCoord2f(1.0, 1.0);			
		glVertex3f(-1.0f,-1.0f,-1.0f);
		//glTexCoord2f(0.0, 1.0);				
		glVertex3f( 1.0f,-1.0f,-1.0f);			

		//glTexCoord2f(0.0, 0.0);	
		glVertex3f( 1.0f, 1.0f, 1.0f);			
		//glTexCoord2f(1.0, 0.0);	
		glVertex3f(-1.0f, 1.0f, 1.0f);
		//glTexCoord2f(1.0, 1.0);				
		glVertex3f(-1.0f,-1.0f, 1.0f);
		//glTexCoord2f(0.0, 1.0);				
		glVertex3f( 1.0f,-1.0f, 1.0f);			

		//glTexCoord2f(0.0, 0.0);	
		glVertex3f( 1.0f,-1.0f,-1.0f);			
		//glTexCoord2f(1.0, 0.0);	
		glVertex3f(-1.0f,-1.0f,-1.0f);			
		//glTexCoord2f(1.0, 1.0);	
		glVertex3f(-1.0f, 1.0f,-1.0f);
		//glTexCoord2f(0.0, 1.0);				
		glVertex3f( 1.0f, 1.0f,-1.0f);			

		//glTexCoord2f(0.0, 0.0);	
		glVertex3f(-1.0f, 1.0f, 1.0f);
		//glTexCoord2f(1.0, 0.0);				
		glVertex3f(-1.0f, 1.0f,-1.0f);
		//glTexCoord2f(1.0, 1.0);				
		glVertex3f(-1.0f,-1.0f,-1.0f);
		//glTexCoord2f(0.0, 1.0);				
		glVertex3f(-1.0f,-1.0f, 1.0f);			

		//glTexCoord2f(0.0, 0.0);	
		glVertex3f( 1.0f, 1.0f,-1.0f);
		//glTexCoord2f(1.0, 0.0);				
		glVertex3f( 1.0f, 1.0f, 1.0f);
		//glTexCoord2f(1.0, 1.0);				
		glVertex3f( 1.0f,-1.0f, 1.0f);
		//glTexCoord2f(0.0, 1.0);				
		glVertex3f( 1.0f,-1.0f,-1.0f);			

        glEnd();
		//glDisable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);
                   
        glEnable(GL_LIGHTING);
        
        glPopMatrix();
            
            
        OutFile1 << "Velocity is set to:  x " << Particles[i].Vel.getX() + TotalForce.getX() << endl;
		OutFile1 << "Velocity is set to:  y " << Particles[i].Vel.getY() + TotalForce.getY() << endl;
		OutFile1 << "Velocity is set to:  z " << Particles[i].Vel.getZ() + TotalForce.getZ() << endl << endl;
            
		//update the velocity
		Particles[i].Vel.setX(Particles[i].Vel.getX() + TotalForce.getX());
		Particles[i].Vel.setY(fabs(Particles[i].Vel.getY()) + TotalForce.getY());
		Particles[i].Vel.setZ(Particles[i].Vel.getZ() + TotalForce.getZ());
		
		OutFile1 << "New pos is set to:  x " << Particles[i].Pos.getX() + Particles[i].Vel.getX() << endl;
		OutFile1 << "New pos is set to:  y " << Particles[i].Pos.getY() + Particles[i].Vel.getY() << endl;
		OutFile1 << "New pos is set to:  z " << Particles[i].Pos.getZ() + Particles[i].Vel.getZ() << endl << endl;
			
		//update the position from position and velocity	
		Particles[i].Pos.setX(Particles[i].Pos.getX() + Particles[i].Vel.getX());
		Particles[i].Pos.setY(Particles[i].Pos.getY() + Particles[i].Vel.getY());
		Particles[i].Pos.setZ(Particles[i].Pos.getZ() + Particles[i].Vel.getZ());
		
		OutFile1 << "Pos is now after: " << Particles[i].Pos.getX() << " " << Particles[i].Pos.getY() << " " << Particles[i].Pos.getZ() << endl;
				
		//add 1 to the age
		Particles[i].age++;

		//check age relative to lifespan                
		if(Particles[i].age > Particles[i].LifeSpan) 
        {
            InitParticle(i);
		    //Particles[i].age = -1;
		}
		
		OutFile1 << "Pos is now last in loop: " << Particles[i].Pos.getX() << " " << Particles[i].Pos.getY() << " " << Particles[i].Pos.getZ() << endl;
     }
   }
   all_drawn = true;
}
   





