/*
 * Skybox is a non-updateable GameObject which draws the skybox.
 */

#ifndef SKYBOX_H_
#define SKYBOX_H_

#include <SDL_opengl.h>
#include <SDL.h>

#include "GameObject.h"

#define DEFAULT_SKYBOX_SIZE 100

enum SkyboxTexture { FRONT_TEXTURE, LEFT_TEXTURE, RIGHT_TEXTURE, BACK_TEXTURE, UP_TEXTURE, DOWN_TEXTURE };

/* GameObject that renders the skybox */
class Skybox: public GameObject {
  public:
    /* construct with reference to world */
    Skybox(GameWorld& gw);

    /* destructor */
    ~Skybox();

    /* load textures */
    void load();

    /* draw the skybox */
    void draw();

  private:
    /* textures */
    GLuint textures[6];
};

#endif /*SKYBOX_H_*/
