/*ParticleSystem.cpp*/


#include "ParticleSystem.h"
#include <time.h>
#include <iostream>

using namespace std;


void ParticleSystem::InitParticles()
{
   for(int i = 0; i < particleNum; i++)
   {
      InitParticle(i);        
   }
}
          
void ParticleSystem::InitParticle(int i)
{
     //set the init position of the particles
     Particles[i].IPos.setX(IPos.getX()); 
     Particles[i].IPos.setY(IPos.getY());
     Particles[i].IPos.setZ(IPos.getZ());

     //set position to be initial position
     Particles[i].Pos.setX(IPos.getX()); 
     Particles[i].Pos.setY(IPos.getY());
     Particles[i].Pos.setZ(IPos.getZ());

     //set a random velocity, calculated from the Vel you gave in Init
     Particles[i].Vel.setX(((rand()%(100))/100.0) * Vel.getX() - Vel.getX()/2);
     Particles[i].Vel.setY(((rand()%(100))/100.0) * Vel.getY() - Vel.getY()/2);
     Particles[i].Vel.setZ(((rand()%(100))/100.0) * Vel.getZ() - Vel.getZ()/2);
    
     //set age of particle          
     Particles[i].age = 0;
     //set a random lifespan
     Particles[i].LifeSpan = rand()%(LifeSpan+1);
}
                      

//ipos is the initial position where you want the particle to start
void ParticleSystem::Init(long num_part, long num_forces, Vec3f Forces[], Vec3f vel, Vec3f ipos, float color[], int lifespan)
{
     //initialize rand
     srand (time(NULL));

     //num_part is number of particles, create an array of particles
     Particles = new Particle[num_part];
     particleNum = num_part;
     //add the force to the totalforce
     for (int i = 0; i < num_forces; i++)
     {
        TotalForce.setX(TotalForce.getX() + Forces[i].getX());  
        TotalForce.setY(TotalForce.getY() + Forces[i].getY()); 
        TotalForce.setZ(TotalForce.getZ() + Forces[i].getZ());   
     }     
     IPos = ipos;
     Vel = vel;
     LifeSpan = lifespan;
}
				
ParticleSystem::~ParticleSystem() 
{ 
    delete Particles; 
}
