/*
 * Mountain is a non-updateable GameObject which draws a mountain landscape.
 */

#ifndef MOUNTAIN_H_
#define MOUNTAIN_H_

#include <SDL_opengl.h>
#include <SDL.h>

#include "Terrain.h"
#include "GameWorld.h"
#include "HeightMap.h"

#define DEFAULT_MOUNTAIN_SIZE 80

/* GameObject that renders as the mountain terrain */
class Mountain: public Terrain {
  public:
    /* construct with reference to world */
    Mountain(GameWorld& gw);

    /* destructor */
    ~Mountain();

    /* load textures */
    void load();
};

#endif /*MOUNTAIN_H_*/
