/*
 * Mountain implementation.
 */

#include <SDL_opengl.h>
#include <SDL.h>

#include "Mountain.h"
#include "FractalHeightMap.h"

/* construct with reference to world */
Mountain::Mountain(GameWorld& gw): Terrain(gw) {
    // set size
    setWidth(DEFAULT_TERRAIN_SIZE);
    setLength(DEFAULT_TERRAIN_SIZE);
    
    // load height map
    heightMap = new FractalHeightMap();
    
    // initialize mountain patches
    initPatches();
}

/* destructor */
Mountain::~Mountain() {
    // free all mountain patches
    for (int i = 0; i < NUM_PATCHES_PER_SIDE; i++) {
        for (int j = 0; j < NUM_PATCHES_PER_SIDE; j++) {
            free(patches[i][j]);
        }
    }
    
    // free quad tree
    free(patchTree);
    
    // free height map
    free(heightMap);
}

/* load textures */
void Mountain::load() {
    // SDL surface
    SDL_Surface* surface = SDL_LoadBMP("imgs/terrain-ground.bmp");
    
    // generate texture
    glGenTextures(1, textures);
    glBindTexture(GL_TEXTURE_2D, textures[TERRAIN_BASE_TEXTURE]);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
    gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, surface->w, surface->h,
              GL_BGR, GL_UNSIGNED_BYTE, surface->pixels);
    
    // free surface
    SDL_FreeSurface(surface);
}
