/*
 * on-screen mini-map and control panel
 */
#ifndef MINIMAP_H_
#define MINIMAP_H_

#include <string>
#include <SDL_ttf.h>

#include "GameObject.h"
#include "GameWorld.h"

using namespace std;

/* on-screen mini-map */
class MiniMap: public GameObject {
  public:
    /* constructor */
	MiniMap(GameWorld& gw);
    
    /* destructor */
	virtual ~MiniMap();
    
    /* draw minimap */
    void draw();
    
    /* draw a spot on the map for an object */
    void mapObject(GameObjPtr obj, Uint32 color, int spotSize = 5);
    
    /* set show end screen */
    void setShowEnd(bool v) { showEnd = v; }
    
    /* set show cow removed */
    void setShowCowRemoved(bool v);
    
    /* set clock starting time */
    void setStartTime(Uint32 v) { startTime = v; }
    
    /* set the total time */
    void setTotalTime(Uint32 v) { totalTime = v; }
    
  private:
    /* map surface and font data */
    SDL_Surface* map;
    SDL_Surface* icon;
    SDL_Surface* timer;
    TTF_Font* fontSm;
    TTF_Font* fontLg;
    
    
    /* map w and h and offset */
    int mapW;
    int mapH;
    int offsetX;
    int offsetY;
    
    /* icon and timer w and h */
    int iconW, iconH, timerW, timerH;

    /* starting time in milliseconds */
    Uint32 startTime;
    /* total time in milliseconds */
    Uint32 totalTime;
    /* elapsed time in milliseconds */
    Uint32 elapsedTime;
    
    /* show start/end screens */
    SDL_Surface* endScreen;
    SDL_Surface* cowRemoved;
    bool showEnd;
    bool showCowRemoved;
    
    /* cow msg array */
    string cowMsg[4];
    int randomMsg;
    
    /* time to show cow msg */
    Uint32 cowTime;
};

#endif /*MINIMAP_H_*/
