// mesh.h: interface for the mesh class.
//
//////////////////////////////////////////////////////////////////////
#ifndef MESH_H
#define MESH_H


#include <stdio.h>
#include <stdlib.h>
#include <map>
#include <vector>
#include <string>

#include <SDL_opengl.h>
#include <SDL.h>

#include "Vertex.h"
#include "Material.h"

#include "Vec3f.h"
#include "Vertex.h"
#include "Material.h"

using namespace std;

/* typedefs for convenience */
typedef vector<Vertex> Face;
typedef vector<Face> FaceList;
typedef map<string, FaceList> FaceMap;
typedef map<string, Material> MatlMap;

class Mesh  
{
	
public:
    
    /* init with model name, used to locate model files */
    Mesh(string name);
    
    /* destructor */
    virtual ~Mesh();

    /* render the mesh */
    void render(void);
    
    /* return path to file associated with this mesh */
    string getPath(string fileName);
    
    /* get the material map */
    MatlMap& getMatlMap() { return matlMap; }
    
    /* utility method to load a texture from bmp */
    static GLuint loadTexture(string fileName);

 private:
    GLuint dspList;
    string modelName; //model name

    int nVertices, nTextureCoords, nNorms, nMaterials;

    vector<Vec3f>    vList;      // Vertex List
    vector<Vec3f>    nList;      // Normal List
    vector<Vec3f>    tList;      // Texture List
    
    FaceMap     faceMap;   // matl name -> face list
    MatlMap     matlMap; // matl name -> material

    void buildDspList(void);
    void LoadMesh(string scene_file);
    void LoadTex(string tex_file);
    
    /* get the actual index into a vector, from a possibly negative input */
    int getIndex(size_t vecSize, string indexStr);

};


/* helper method to tokenize a string */
void tokenize(vector<string>& tokens, const string& str, const string& delimiters);

/* helper method to split a string */
void split(vector<string>& tokens, const string& str, const string& delimiters) ;

#endif
