/*
 * Class to read in an image Height Map for terrain
 * generation
 */
 
#ifndef IMAGE_HEIGHTMAP_H_
#define IMAGE_HEIGHTMAP_H_

#include <SDL_opengl.h>
#include <SDL.h>

#include "HeightMap.h"

/* read in a Height Map for terrain info */
class ImageHeightMap: public HeightMap {
  public:
    /* constructor */
    ImageHeightMap();
    
    /* destructor */
    virtual ~ImageHeightMap();

    /* get the height at location */
    GLfloat getHeight(GLfloat xPos, GLfloat zPos);
    
    /* load height from img */
    void loadFromImage(const char *file);

  private:
    /* storage of height data */
    SDL_Surface* map;

    /* the center of the map data, used in height lookups */
    int centerX;
    int centerZ;
};

#endif /*IMAGE_HEIGHTMAP_H_*/
