/*
 * Class to read in an image Height Map for terrain
 * generation
 */

#include <cmath>
#include <iostream>

#include "ImageHeightMap.h"

using namespace std;

extern bool statsMode;

/* default constructor */
ImageHeightMap::ImageHeightMap(): map(NULL) {
    loadFromImage("imgs/height_map.bmp");
}

/* destructor */
ImageHeightMap::~ImageHeightMap() {
    if (map != NULL) {
        SDL_FreeSurface(map);
    }
}

/* load height from img */
void ImageHeightMap::loadFromImage(const char *file) {
    map = SDL_LoadBMP(file);
    if (map == NULL) {
        cout << "Load HeightMap Failed! " << file << endl;
    }
    if (statsMode) {
        cout << "Must Lock: " << SDL_MUSTLOCK(map) << endl;
    }
    
    centerX = map->w / 2;
    centerZ = map->h / 2;
}

/* get the height at location */
GLfloat ImageHeightMap::getHeight(GLfloat xPos, GLfloat zPos) {
    static const GLfloat maxHeight = 50;
    
    int x = (int)rint(xPos) + centerX;
    int z = (int)rint(zPos) + centerZ;
    if (x < 0 || z < 0 || x > map->w || z > map->h) {
        return 0; // lookup outside map
    } else {
        unsigned char* data = (unsigned char*)map->pixels;
        return (data[(x * map->w) + z] / 255.0f) * maxHeight;
    }
}
