/*
 * House implementation
 */

#include "House.h"



/* construct with reference to game world */
House::House(GameWorld& gw): GameObject(gw) {
    // set generic GameObject param
    setWidth(4);
    setLength(4);
    setHeight(4);
    
    object_h = new Mesh ("house1");
}


void House::draw()
{

    // isolate transforms
    glPushMatrix();

    // translate to a location
    glTranslatef(0, loc.getY(), loc.getZ());
    
    // draw vel/normal for debugging
    drawDebugInfo();
    
    // scale this object
    glScalef(.005, .005, .005);

    //render
    object_h->render();
	
    //pop matrix
    glPopMatrix();
}

