/*Gravel.cpp*/

#include "Gravel.h"
#include "Mesh.h"
#include <iostream>
#include <time.h>

using namespace std;

extern bool statsMode;

//constructor
Gravel::Gravel(float force_x)
{
	n_forces=1;
	f[0].setX(force_x);
	f[0].setY(-2);
	vel.setX(2);
	vel.setY(10);     

	scale = 0.5;

    if (statsMode) {
	   cout << "Gravel constructor" << endl;
    }       
};

void Gravel::In()
{
    if (statsMode) {
        cout << "Into In()" << endl;
    }
     Init(100, n_forces, f, vel, init_pos, 20);
}

//load the texture for the gravel
GLuint Gravel::getTexture() {
    static GLuint textureId(0);
    if (textureId == 0) {
        textureId = Mesh::loadTexture(string("imgs/dirt.bmp"));
    }
    return textureId;
}


//draw the particlesystem
void Gravel::Render()
{
  //initialize rand
  srand (time(NULL));
		
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_DST_ALPHA); //GL_ONE_MINUS_SRC_ALPHA); 
    
    glEnable(GL_TEXTURE_2D);
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    glBindTexture(GL_TEXTURE_2D, getTexture());
    //set material to white
    GLfloat white[] = { 1.0, 1.0, 1.0, 1.0 };
    glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, white);
    
  for(int i=0; i < particleNum; i++)
  {
     if(Particles[i].age >= 0) //only draw if they are "alive"
     {
		glPushMatrix();
                   
		//scale the gravel down to a fixed size
		glScalef(0.05, 0.05, 0.05);

		//scale the gravel randomly from this size
		glScalef( rand()%(100)/100.0, rand()%(100)/100.0, rand()%(100)/100.0 );

		//if too old make even smaller
		if(Particles[i].age >= 4)
		{
		   glScalef(scale,scale,scale);
		}

		glTranslatef(Particles[i].Pos.getX(), Particles[i].Pos.getY(), Particles[i].Pos.getZ());
	
     	glBegin(GL_QUADS);
       
		glTexCoord2f(0.0, 0.0);
		glVertex3f( 1.0f, 1.0f,-1.0f);	
		glTexCoord2f(1.0, 0.0);		
		glVertex3f(-1.0f, 1.0f,-1.0f);	
		glTexCoord2f(1.0, 1.0);		
		glVertex3f(-1.0f, 1.0f, 1.0f);
		glTexCoord2f(0.0, 1.0);			
		glVertex3f( 1.0f, 1.0f, 1.0f);			

		glTexCoord2f(0.0, 0.0);
		glVertex3f( 1.0f,-1.0f, 1.0f);	
		glTexCoord2f(1.0, 0.0);			
		glVertex3f(-1.0f,-1.0f, 1.0f);	
		glTexCoord2f(1.0, 1.0);			
		glVertex3f(-1.0f,-1.0f,-1.0f);
		glTexCoord2f(0.0, 1.0);				
		glVertex3f( 1.0f,-1.0f,-1.0f);			

		glTexCoord2f(0.0, 0.0);	
		glVertex3f( 1.0f, 1.0f, 1.0f);			
		glTexCoord2f(1.0, 0.0);	
		glVertex3f(-1.0f, 1.0f, 1.0f);
		glTexCoord2f(1.0, 1.0);				
		glVertex3f(-1.0f,-1.0f, 1.0f);
		glTexCoord2f(0.0, 1.0);				
		glVertex3f( 1.0f,-1.0f, 1.0f);			

		glTexCoord2f(0.0, 0.0);	
		glVertex3f( 1.0f,-1.0f,-1.0f);			
		glTexCoord2f(1.0, 0.0);	
		glVertex3f(-1.0f,-1.0f,-1.0f);			
		glTexCoord2f(1.0, 1.0);	
		glVertex3f(-1.0f, 1.0f,-1.0f);
		glTexCoord2f(0.0, 1.0);				
		glVertex3f( 1.0f, 1.0f,-1.0f);			

		glTexCoord2f(0.0, 0.0);	
		glVertex3f(-1.0f, 1.0f, 1.0f);
		glTexCoord2f(1.0, 0.0);				
		glVertex3f(-1.0f, 1.0f,-1.0f);
		glTexCoord2f(1.0, 1.0);				
		glVertex3f(-1.0f,-1.0f,-1.0f);
		glTexCoord2f(0.0, 1.0);				
		glVertex3f(-1.0f,-1.0f, 1.0f);			

		glTexCoord2f(0.0, 0.0);	
		glVertex3f( 1.0f, 1.0f,-1.0f);
		glTexCoord2f(1.0, 0.0);				
		glVertex3f( 1.0f, 1.0f, 1.0f);
		glTexCoord2f(1.0, 1.0);				
		glVertex3f( 1.0f,-1.0f, 1.0f);
		glTexCoord2f(0.0, 1.0);				
		glVertex3f( 1.0f,-1.0f,-1.0f);			

        glEnd();
                   
        glPopMatrix();
            
		//update the velocity
		Particles[i].Vel.setX(Particles[i].Vel.getX() + TotalForce.getX());
		Particles[i].Vel.setY(Particles[i].Vel.getY() + TotalForce.getY());
		Particles[i].Vel.setZ(Particles[i].Vel.getZ() + TotalForce.getZ());
			
		//update the position from position and velocity	
		Particles[i].Pos.setX(Particles[i].Pos.getX() + Particles[i].Vel.getX());
		Particles[i].Pos.setY(Particles[i].Pos.getY() + Particles[i].Vel.getY());
		Particles[i].Pos.setZ(Particles[i].Pos.getZ() + Particles[i].Vel.getZ());
				
		//add 1 to the age
		Particles[i].age++;

		//check age relative to lifespan                
		if(Particles[i].age > Particles[i].LifeSpan) 
        {
		      Particles[i].age = -1;
		}
     }
   }
   
        glDisable(GL_TEXTURE_2D);
        glDisable(GL_BLEND);
}
   
/* check if all particle have died */
bool Gravel::allParticlesDead() {
    for(int i=0; i < particleNum; i++) {
        if(Particles[i].age >= 0) {
            return false;
        }
    }
    return true;
}



