/*
 * Represents the game loop, constant loop of updating
 * game world and handling input events, with frame 
 * throttling as necessary
 */

#ifndef GAMELOOP_H_
#define GAMELOOP_H_

#include <SDL.h>
#include <SDL_mixer.h>

#include "GameWorld.h"

/*
 * Class represents the game loop, constant loop of updating
 * game world and handling input events, with frame 
 * throttling as necessary
 */
class GameLoop {
  public:
    /* time per frame, in millis (1000/fps) */
    static const Uint32 TIME_PER_FRAME = 40;
  
    /* construct with reference to a game world */
	GameLoop(GameWorld& gw);
	
    /* destructor */
    ~GameLoop();
    
    /* start the loop */
    void start();
    
    /* end the loop and exit program */
    void exit();
    
    /* main music chunk */
    Mix_Chunk* getMusic() { return music; }
    
    /* main music channel */
    int getMusicChannel() { return musicChannel; }
    
  private:
    /* reference to the game world */
    GameWorld& gameWorld;
    
    /* boolean to exit loop */
    bool endLoop;
    
    /* main music chunk */
    Mix_Chunk* music;
    
    /* main music channel */
    int musicChannel;
    
    /* no one should use assignment operator for this class */
    GameLoop& operator=(const GameLoop& rhs);
    /* no one should use copy constructor for this class */
    GameLoop(const GameLoop& rhs);
};

#endif /*GAMELOOP_H_*/
