/*
 * Class to read in a fractally generated Height Map for terrain
 * generation
 */

#ifndef FRACTAL_HEIGHTMAP_H_
#define FRACTAL_HEIGHTMAP_H_

#include "HeightMap.h"

#define DEFAULT_OFFSET 0
#define DEFAULT_OCTAVES 3
#define DEFAULT_ROUGHNESS 0.9
#define DEFAULT_LACUNARITY 1.9

/* Fractal generator used to procedurally generate the terrain surface */
class FractalHeightMap: public HeightMap {
  public:
    /* default constructor, initializes members */
    FractalHeightMap();

    /* destructor */
    FractalHeightMap::~FractalHeightMap();

    /* get the height at location */
    GLfloat getHeight(GLfloat xPos, GLfloat zPos);

    /* set offset */
    void setOffset(float f) { offset = f; }

    /* set the number of octaves */
    void setOctaves(float o) { octaves = o; }

    /* set the roughness factor */
    void setRoughness(float r) { roughness = r; }

    /* set the lacunarity value */
    void setLacunarity(float l) { lacunarity = l; }

  private:
    /* initialize the frequency weight map used to generate fractal */
    void initFrequencyWeights();

    /* returns a random value with the given inputs */
    float randomValue(float x, float z);

    /* returns a smoothed, weighted sum of random values given the inputs */
    float smooth(float x, float z);

    /* returns the linear interpolation between the given inputs with the fractional weight */
    float lerp(float x, float z, float fraction);

    /* generates a noise value given the inputs */
    float noise(float x, float z);

    // frequency weight map
    float* frequencyWeights;

    float offset;
    float octaves;
    float roughness;
    float lacunarity;
};

#endif /*FRACTAL_HEIGHTMAP_H_*/
