/*
 * Fence impl
 */

#include "Fence.h"
#include "GameWorld.h"
#include "Frustum.h"

/* construct with ref to world */
Fence::Fence(GameWorld& gw): GameObject(gw) {
    // set sizes
    setWidth(0.5);
    setLength(0.5);
    setHeight(0.5);
}

/* load textures */
void Fence::load() {
    // SDL surface
    SDL_Surface* surface = SDL_LoadBMP("imgs/fence.bmp");
    
    // generate texture
    glGenTextures(1, &texture);
    glBindTexture(GL_TEXTURE_2D, texture);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
    gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, surface->w, surface->h,
              GL_BGR, GL_UNSIGNED_BYTE, surface->pixels);
    
    // free surface
    SDL_FreeSurface(surface);
}

/* draw a fence, a skinny post for now */
void Fence::draw() {
    if (world.getViewFrustum()->objectIntersects(this) > OUTSIDE_FRUSTUM) {
        glPushMatrix();
        glTranslatef( loc.getX(), loc.getY(), loc.getZ());
        
        // draw debug info
        drawDebugInfo();
    
        //glScalef( .25, 2, .25);
        
        // move fence above ground
        glTranslatef(0, 2, 0);
        
        glColor3f(1, 1, 1);
        GLfloat white[] = { 1.0, 1.0, 1.0, 1.0 };
        glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, white);
        glEnable(GL_TEXTURE_2D);
        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
        glBindTexture(GL_TEXTURE_2D, texture);
        glBegin(GL_QUADS);
            // front
            glNormal3f(0, 0, 1);
            glTexCoord2f(0, 0);
            glVertex3f(-0.25, -2, 0.25);
            glTexCoord2f(0.25, 0);
            glVertex3f(0.25, -2, 0.25);
            glTexCoord2f(0.25, 1);
            glVertex3f(0.25, 2, 0.25);
            glTexCoord2f(0, 1);
            glVertex3f(-0.25, 2, 0.25);
            
            // back
            glNormal3f(0,  0, -1);
            glTexCoord2f(0.75, 0);
            glVertex3f(-0.25, -2, -0.25);
            glTexCoord2f(0.75, 1);
            glVertex3f(-0.25, 2, -0.25);
            glTexCoord2f(0.5, 1);
            glVertex3f(0.25, 2, -0.25);
            glTexCoord2f(0.5, 0);
            glVertex3f(0.25, -2, -0.25);
            
            // right
            glNormal3f(1,  0,  0);
            glTexCoord2f(0.5, 0);
            glVertex3f(0.25, -2, -0.25);
            glTexCoord2f(0.5, 1);
            glVertex3f(0.25, 2, -0.25);
            glTexCoord2f(0.25, 1);
            glVertex3f(0.25, 2, 0.25);
            glTexCoord2f(0.25, 0);
            glVertex3f(0.25, -2, 0.25);
            
            // left
            glNormal3f(-1, 0, 0);
            glTexCoord2f(0.75, 0);
            glVertex3f(-0.25, -2, -0.25);
            glTexCoord2f(1, 0);
            glVertex3f(-0.25, -2, 0.25);
            glTexCoord2f(1, 1);
            glVertex3f(-0.25, 2, 0.25);
            glTexCoord2f(0.75, 1);
            glVertex3f(-0.25, 2, -0.25);
            
            // top
            glNormal3f(0, 1, 0);
            glTexCoord2f(0, 1);
            glVertex3f(-0.25, 2, -0.25);
            glTexCoord2f(0, 0);
            glVertex3f(-0.25, 2, 0.25);
            glTexCoord2f(1, 0);
            glVertex3f(0.25, 2, 0.25);
            glTexCoord2f(1, 1);
            glVertex3f(0.25, 2, -0.25);
            
            // bottom
            glNormal3f(0, -1, 0);
            glTexCoord2f(0, 1);
            glVertex3f(-0.25, -2, -0.25);
            glTexCoord2f(0, 0);
            glVertex3f(-0.25, -2, 0.25);
            glTexCoord2f(1, 0);
            glVertex3f(0.25, -2, 0.25);
            glTexCoord2f(1, 1);
            glVertex3f(0.25, -2, -0.25);
        glEnd();
        glDisable(GL_TEXTURE_2D);
        
        glPopMatrix();
    }
}
