/*
 * 
 * Class that encapsulates Display details, such as
 * window width, height... etc.  Also handles initialization
 * of SDL frameworks 
 *
 */
 
#ifndef DISPLAY_H_
#define DISPLAY_H_

#include <SDL.h>
#include <SDL_mixer.h>

/*
 * Class that sets up the display (and audio etc later?)
 */
class Display {
  public:
    /* window width */
    static const int WIDTH = 1024;
    /* window height */
    static const int HEIGHT = 700;
    /* bits per pixel */
    static const int BPP = 32;
    /* audio rate */
    static const int AUDIO_RATE = 10050;
    /* audio channels */
    static const int AUDIO_CHANNELS = 2;
    /* audio buffer */
    static const int AUDIO_BUFFER = 1024;
    /* audio format */
    static const Uint16 AUDIO_FORMAT = AUDIO_S16SYS;

    /* initialize SDL display and audio */
    static void init();
};

#endif /*DISPLAY_H_*/
