/*
 * 
 * Static class that encapsulates Display details, such as
 * window width, height... etc.  Also handles initialization
 * of SDL frameworks 
 *
 */
#include <iostream>
#include <SDL_opengl.h>
#include <SDL.h>
#include <SDL_ttf.h>
#include <SDL_mixer.h>

#include "Display.h"

using namespace std;

extern bool musicMode;
extern bool statsMode;

PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;
PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2fARB;
GLint numMultitextures;

/* initialize SDL display */
void Display::init() {
    // initialize SDL windows and subsystems
    SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO);
    int flags = SDL_OPENGL;// | SDL_FULLSCREEN;
    
    // opengl specific settings    
    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
    SDL_GL_SetAttribute( SDL_GL_MULTISAMPLEBUFFERS, 1);
    SDL_GL_SetAttribute( SDL_GL_MULTISAMPLESAMPLES, 4);
    
    SDL_SetVideoMode(WIDTH, HEIGHT, BPP, flags); 
    
    if (statsMode) {
        // check multisampling
        GLint bufs, samples;
        glGetIntegerv(GL_SAMPLE_BUFFERS, &bufs);
        glGetIntegerv(GL_SAMPLES, &samples);
        cout << "GL_SAMPLE_BUFFERS: " << bufs << " GL_SAMPLES: " << samples << endl;
    }
    
    // initialize multitexturing
    glGetIntegerv(GL_MAX_TEXTURE_UNITS, &numMultitextures);
    glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC)SDL_GL_GetProcAddress("glActiveTextureARB");
    glMultiTexCoord2fARB = (PFNGLMULTITEXCOORD2FARBPROC)SDL_GL_GetProcAddress("glMultiTexCoord2fARB");
    if (statsMode) {
        cout << "GL_MAX_TEXTURE_UNITS: " << numMultitextures << endl;
    }
    
    // initialize audio
    if (musicMode) {
        if (Mix_OpenAudio(AUDIO_RATE, AUDIO_FORMAT, AUDIO_CHANNELS, AUDIO_BUFFER) != 0) {
            cout << "Failed to initialize audio " << Mix_GetError() << endl;
        }
    }
    
    // enable keyboard repeat
    SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
    
    // initialize fonts
    if ( TTF_Init() == -1 ) {
        cout << "TTF_Init Failed " << TTF_GetError() << endl;
    }
}

/* storage definitions for static vars */
const int Display::WIDTH;
const int Display::HEIGHT;
const int Display::BPP;
const int Display::AUDIO_RATE;
const int Display::AUDIO_CHANNELS;
const int Display::AUDIO_BUFFER;
const Uint16 Display::AUDIO_FORMAT;
