/*
 * the Cow class, renders cow and implements
 * Boids behavior
 */
#ifndef COW_H_
#define COW_H_

#include "GameObject.h"
#include "GameWorld.h"
#include "Mesh.h"

class Cow: public GameObject {
  public:
    /* construct with game world */
    Cow(GameWorld& gw);
  
    /* draw a cow at current location */
    virtual void draw();
    
    /* updates this object according to time elapsed, by default does nothing */
    void update(Uint32 timeElapsed);
    
    /* reset the cow's state */
    void reset();
    
    /*  add inside corral checking to keep from leaving corral */
    virtual bool checkNewLoc(Vec3f newLoc);
    
    /* signal that truck has sounded horn */
    void applyHorn();
    
    /* get the cow bounds */
    static GLfloat getCowBounds();
    
  private:
    /* mesh for cow */
    Mesh* mesh;
    /* max acceleration */
    GLfloat maxAccel;
    /* minimum dist where objects start to repel before collision */
    GLfloat minDist;
    /* weight settings for boids behavior */
    GLfloat ruleCenterWeight;
    GLfloat ruleCollisionWeight;
    GLfloat ruleTruckWeight;
    GLfloat ruleMatchWeight;
    GLfloat ruleInboundsWeight;
    GLfloat ruleHornWeight;
    /* whether this cow is still in the game */
    bool removedFromGame;
    /* previous angleY, to control rotations */
    GLfloat prevAngleY;
    /* max angle to rotate at any one time */
    GLfloat maxRotateAngle;
    /* keep track of truck horn duration */
    Uint32 hornStart;
    GLfloat hornRange;
    Uint32 hornDuration;
    
    
    
    /* velocity rule for going towards center of neighbors */
    Vec3f ruleCenterFlock();
    
    /* velocity rule for avoiding collision */
    Vec3f ruleAvoidCollision();
    
    /* velocity rule for matchig velocity of neighbors */
    Vec3f ruleMatchVelocity();
    
    /* velocity rule for avoiding truck */
    Vec3f ruleAvoidTruck();
    
    /* velocity rule for staying in bounds of world */
    Vec3f ruleStayInbounds();
    
    /* velocity rule for truck horn */
    Vec3f ruleHorn();
  
    /* accumulate into vector, with limit max */
    void accumulate(Vec3f& target, Vec3f addAmt, GLfloat maxMag);
  
    /* get list of cows in the vicinity, that will affect boids behavior */
    GameObjVec& getNearbyCows();
        
    /* get list of objects to avoid collision from */
    GameObjVec getNearbyObjs();
    
    /* rotate this cow (in opengl) to match velocity vector */
    void rotateToVel();
    
    /* get a shared mesh for all cows */
    static Mesh* getCowMesh();
    
};


#endif /*COW_H_*/
