/*
 * Class that defines the "Corral" that the
 * cows should get herded into.  Not really a real GameObject
 * right now, because we have very simple collision detection.
 * Just draws a bunch of Fences and defines an area.
 *  
 */
#ifndef CORRAL_H_
#define CORRAL_H_

#include "GameWorld.h"
#include "GameObject.h"

/* class that deals with the "target" area for herding the cows */
class Corral: public GameObject {
  public:
    /* construct the corral using Fence objs for now */
    Corral(GameWorld& gw);
    
    /* do nothing in draw */
    void draw() {}  
    
    /* test if obj location is in corral */
    bool isInCorral(Vec3f objLoc);
    
    /* get fences that make up this corral */
    GameObjVec& getFences() { return fences; }
    
  private:
    /* store some corral dimensions */
    GLfloat radius;
    /* store fences */
    GameObjVec fences;
    
};  


#endif /*CORRAL_H_*/
