/*
 * corral impl
 */
#include <cmath>

#include "Corral.h"
#include "Terrain.h"
#include "Fence.h"
#include "GameWorld.h"
#include "Cow.h"

using namespace std;

/* construct the corral using Fence objs for now */
Corral::Corral(GameWorld& gw): GameObject(gw), radius(10) {
    setWidth(20);
    setLength(20);
    
    // create a target area with fences
    // set location to corner of cow's map boundaries
    setLocation(-Cow::getCowBounds() + radius, 
                0, 
                -Cow::getCowBounds() + radius);
    
    // add top fence
    for (int i = getX() + xMin; i < getX() + xMax; i += 2) {
        GameObjPtr obj(new Fence(world));
        obj->load();
        obj->setLocation(i, 0, getZ() + zMax);
        world.addGameObj(obj, false, true);
        fences.push_back(obj);
    }
    
    // add bottom fence
    for (int i = getX() + xMin; i < getX() + xMax; i += 2) {
        GameObjPtr obj(new Fence(world));
        obj->load();
        obj->setLocation(i, 0, getZ() + zMin);
        world.addGameObj(obj, false, true);
        fences.push_back(obj);
    }
    
    // add left fence
    for (int i = getZ() + zMin + 2; i < getZ() + zMax; i += 2) {
        GameObjPtr obj(new Fence(world));
        obj->load();
        obj->setLocation(getX() + xMin, 0, i);
        world.addGameObj(obj, false, true);
        fences.push_back(obj);
    }
    
    // add right fence
    for (int i = getZ() + zMin; i <= getZ() + zMax; i += 2) {
        // leave opening for cows
        if (i < getZ() + zMax - 2 && i > getZ() + zMin + 2) {
            continue;
        }
        GameObjPtr obj(new Fence(world));
        obj->load();
        obj->setLocation(getX() + xMax, 0, i);
        world.addGameObj(obj, false, true);
        fences.push_back(obj);
    }
}

/* test if obj is in corral */
bool Corral::isInCorral(Vec3f objLoc) {
    return (objLoc.getX() < loc.getX() + xMax && objLoc.getX() > loc.getX() + xMin &&
            objLoc.getZ() < loc.getZ() + zMax && objLoc.getZ() > loc.getZ() + zMin);
}
