const int numWeights = 7;
const float blurWidth = 2.0;
const float windowHeight = 600.0;


void main()
{
	float pixelDist = blurWidth / windowHeight;
	
	float t = gl_MultiTexCoord0.t - (pixelDist * (float(numWeights) / 2.0)) + pixelDist / 2.0;
	
	/* wouldn't it be nice if this worked on ATI
	for( int i = 0; i < numWeights; i++ )
	{
		gl_TexCoord[i].s = gl_MultiTexCoord0.s;
		gl_TexCoord[i].t = t;
		t += pixelDist;
	}
	*/
	
	gl_TexCoord[0].s = gl_MultiTexCoord0.s;
	gl_TexCoord[0].t = t;
	t += pixelDist;
	
	gl_TexCoord[1].s = gl_MultiTexCoord0.s;
	gl_TexCoord[1].t = t;
	t += pixelDist;
	
	gl_TexCoord[2].s = gl_MultiTexCoord0.s;
	gl_TexCoord[2].t = t;
	t += pixelDist;
	
	gl_TexCoord[3].s = gl_MultiTexCoord0.s;
	gl_TexCoord[3].t = t;
	t += pixelDist;
	
	gl_TexCoord[4].s = gl_MultiTexCoord0.s;
	gl_TexCoord[4].t = t;
	t += pixelDist;
	
	gl_TexCoord[5].s = gl_MultiTexCoord0.s;
	gl_TexCoord[5].t = t;
	t += pixelDist;
	
	gl_TexCoord[6].s = gl_MultiTexCoord0.s;
	gl_TexCoord[6].t = t;
	
	gl_Position = ftransform();
}
