varying vec3 lightHalfVec;

const float lightDepth = -1000.0; // depth below petri dish

void main()
{	
	gl_Position = ftransform();
	
	// position of petri dish texture
	gl_TexCoord[0].st = gl_MultiTexCoord0.st * 2.0;
	gl_TexCoord[1].st = gl_MultiTexCoord0.st * 8.0;
	
	//
	// lighting variables
	//
	
	vec3 vertPos = (gl_ModelViewMatrix * gl_Vertex).xyz;
	
	// light is at center of screen, below petri dish
	vec3 lightPos = vec3( 0.0, 0.0, vertPos.z + lightDepth ); 
	
	vec3 vertToLight = normalize( lightPos - vertPos );
	vec3 vertToEye = normalize( -vertPos );
	lightHalfVec = (vertToLight + vertToEye) / 2.0;
}
