uniform sampler2D texBeneath, texDiffuse, texNormalMap;

const float screen_w = 800.0;
const float screen_h = 600.0;
const float screen_w_half = screen_w / 2.0;
const float screen_h_half = screen_h / 2.0;
const float warp = 0.03;
const float aspect_ratio = (screen_h / screen_w);
const float aspect_ratio_half_inverse = (1.0 - aspect_ratio) / 2.0;

const float shininess = 32.0;
const vec4 specularColor = vec4( vec3( 0.75 ), 1.0 );

varying vec3 lightHalfVec;

void main()
{
	// map normals from 0 to 1 into -1 to +1 
	vec3 normal = 2.0 * (texture2D(texNormalMap, gl_TexCoord[0].st).xyz - 0.5);

	//
	// lookup location on texBeneath based on "displacement" from texNormalMap's normal
	//
	
	// look up 0 - 1 on texture
	vec2 beneathCoord = vec2( (gl_FragCoord.x - 0.5) / screen_w,
							  (gl_FragCoord.y - 0.5) / screen_h );

	// shrink along S so warp doesn't look off of texture
	beneathCoord.s = (beneathCoord.s * (1.0 - warp * 2.0)) + warp; 
	beneathCoord.t = ((beneathCoord.t * (1.0 - warp * 2.0)) + warp) * 0.74; 
	
	// shift T so the center of the screen is the center of the image
	//beneathCoord.t = (beneathCoord.t * aspect_ratio) + aspect_ratio_half_inverse;
	
	vec4 beneath = texture2D( texBeneath, beneathCoord.st + normal.xy * -warp );

	//
	// lighting
	//
	
	// total hacks to get things looking the way I want
	normal.x += 0.4;
	normal.y = -(normal.y + 0.1);
	normal = normalize( normal );
	
	
	float NdotHalfVec = max( 0.0, dot( normal, normalize( lightHalfVec ) ) );
	vec4 specular = specularColor * pow( NdotHalfVec, shininess );
	
	//	
	// blend diffuse color over beneath color
	//
	vec4 diffuse = texture2D( texDiffuse, gl_TexCoord[1].st );
	diffuse.a += specular.a;
	vec3 blended = diffuse.rgb * diffuse.a + beneath.rgb * (1.0 - diffuse.a);
	
	blended.rgb += specular.rgb;
	
	gl_FragColor = vec4( blended, specular.a );
}
