const int numWeights = 7;
const float blurWidth = 2.0;
const float windowWidth = 800.0;


void main()
{
	float pixelDist = blurWidth / windowWidth;
	
	float s = gl_MultiTexCoord0.s - (pixelDist * (float(numWeights) / 2.0)) + pixelDist / 2.0;
	
	/* doesn't work on ATI
	for( int i = 0; i < numWeights; i++ )
	{
		gl_TexCoord[i].s = s;
		gl_TexCoord[i].t = gl_MultiTexCoord0.t;
		s += pixelDist;
	}
	*/
	
	gl_TexCoord[0].s = s;
	gl_TexCoord[0].t = gl_MultiTexCoord0.t;
	s += pixelDist;
	
	gl_TexCoord[1].s = s;
	gl_TexCoord[1].t = gl_MultiTexCoord0.t;
	s += pixelDist;
	
	gl_TexCoord[2].s = s;
	gl_TexCoord[2].t = gl_MultiTexCoord0.t;
	s += pixelDist;
	
	gl_TexCoord[3].s = s;
	gl_TexCoord[3].t = gl_MultiTexCoord0.t;
	s += pixelDist;
	
	gl_TexCoord[4].s = s;
	gl_TexCoord[4].t = gl_MultiTexCoord0.t;
	s += pixelDist;
	
	gl_TexCoord[5].s = s;
	gl_TexCoord[5].t = gl_MultiTexCoord0.t;
	s += pixelDist;
	
	gl_TexCoord[6].s = s;
	gl_TexCoord[6].t = gl_MultiTexCoord0.t;

	
	gl_Position = ftransform();
}
