uniform float creatureRadius;

varying vec3 warpedLookup;
//varying float normDotEye;
//varying vec4 specular;

varying vec3 normal;
varying vec3 halfVec;

const float warp = 0.4; // maximum warp (relative to creature's  radius)
/*
const vec4 specularColor = vec4( vec3( 0.2 ), 1.0 );
const float shininess = 256.0;
*/
const vec3 lightPos = vec3(0.0, 0.0, -300);

void main()
{	
	// set position
	gl_Position = ftransform();

	gl_TexCoord[0].st = gl_MultiTexCoord0.st;
	
	
	//
	// determine refracted position to look at on floor
	//
	
	// position of this vertex
	vec3 vertPos = (gl_ModelViewMatrix * gl_Vertex).xyz;
	
	// normalized normal in proper space
	normal = normalize( gl_NormalMatrix * gl_Normal );
	
	//normDotEye = dot( normal, vec3( 0.0, 0.0, 1.0 ) );
	
	// size of creature's radius, pointing inwards
	vec3 negNormalRadiusSize = -normal * creatureRadius; 
	
	// position of creature's center
	vec3 creatureCenterPos = vertPos + negNormalRadiusSize;
	
	// start by moving towards creature's center...
	vec3 warpedFloorPos = vertPos + (negNormalRadiusSize * warp);

	// ...project onto floor beneath creature
	warpedFloorPos.z = warpedFloorPos.z - creatureRadius - (warpedFloorPos.z - creatureCenterPos.z);
	
	// ...multiply by perspective matrix
	vec4 warpedLookup4 = gl_ProjectionMatrix * vec4( warpedFloorPos, 1.0 );
	
	// ...perspective divide to get map xyz coordinates from -1 to 1
	warpedLookup = warpedLookup4.xyz / warpedLookup4.w;
	
	//
	// specular lighting
	//
	halfVec = ((lightPos - vertPos) - vertPos) / 2.0;
	/*
	float NdotHalfVec = max( 0.0, dot( normal, normalize(halfVec) ) );
	specular = specularColor * pow( NdotHalfVec, shininess );
	*/
}
