uniform sampler2D texBeneath;
uniform vec3 bodyTint;

varying vec3 warpedLookup;
//varying float normDotEye;
//varying vec4 specular;
varying vec3 normal;
varying vec3 halfVec;


const vec3 outlineColor = vec3( 0.0, 0.0, 0.0 );
const vec4 specularColor = vec4( vec3( 0.2 ), 1.0 );
const float shininess = 256.0;

void main()
{
	// 
	// sample appropriate part of floor texture for refraction effect
	//
	
	// map from -1 to 1 into 0 to 1
	vec2 beneathCoord = warpedLookup.xy * 0.5 + 0.5;
	
	// background image isn't as large in y
	beneathCoord.y *= 0.75;
	
	vec4 beneath = texture2D(texBeneath, beneathCoord);
	
	vec3 normFrag = normalize(normal);
	float normDotEyeFrag = dot( normFrag, vec3( 0.0, 0.0, 1.0 ) );
	
	//vec3 blend = bodyColor * (1.0 - normDotEye) + beneath.rgb * normDotEye;
	vec3 blend = (outlineColor * (1.0 - normDotEyeFrag) + beneath.rgb * normDotEyeFrag) * bodyTint;
	
	
	//lighting
	float NdotHalfVec = max( 0.0, dot( normFrag, normalize(halfVec) ) );
	vec4 specular = specularColor * pow( NdotHalfVec, shininess );
	
	blend += specular.rgb;
	
	gl_FragColor = vec4( blend, specular.a );
}
