#ifndef WORLD_H_
#define WORLD_H_

#include "Planet.h"
#include "Sky.h"
#include "Star.h"
#include "Target.h"
#include "Map.h"
#include "Player.h"
#include "Mine.h"
#include "Snake.h"

#define MY_SDL_MIX_MAXVOLUME 32

class World
{
public:
    static Planet ** planets;
    static int * tunnelConnections;

    int height, width;

    World(int numberOfSpheres);
    ~World(void);

    void addSphere(Sphere * s);
    void update();
    int handleEvents();
    void exitPause();
    void draw();
    void drawWelcomeScreen();
    void drawGameOverScreen(int s1, int s2, int s3, int s4);
    void gameOver();

    int mv_forward, mv_backward, mv_left, mv_right, mv_shift, radar_on;
    float *eye, *front, *top, *p, *t, *mapTop, *v;
    float closeTop, closeBehind;
    int n, currentFace;
    int currentPlanet;
    bool lookingDown, onTunnel, pauseGame, onWelcomeScreen, mute, die, wire;
    int gameIsOver, score;
    float dp, dt, maxdp;
    Target ** targets;
    int numberOfAliveTargets;
    Mine * mines[NUMBER_OF_MINES];
    Player * player;
    Snake * snakes[NUMBER_OF_SNAKES];

    GLuint fireTextureId, smokeTextureId, pauseTextureId, whiteTextureId;
    GLuint smallSphereTextureId, smileyTextureId, cylinderTextureId;
    GLuint snakeTextureId, snakeDistantTextureId;
    GLuint planetTextureId1, planetTextureId2, skyTextureId, gameOverTextureId;
    GLuint digitTextureId[11];

    SDL_AudioSpec fmt;
    int playSound(int i, int volume);
    void loadSound(char * file, int i);
    void loadAllSounds();
    void killSound(int sound);
    int playing_shift_sound;

    Uint32 timeOffset;
    Uint32 deltaTimeOffset;
    int timeOfLatestAutodestroy;

    void loadInitialTextures();
    void loadAdditionalTextures();

private:
    GLuint textureId, /*starsTextureId,*/ welcomeTextureId;
    GLfloat LIGHT0_position[4];

    int numberOfSpheres;
    Sphere ** spheres;

    int maxN;
    int video_flags;

    void initLight();
    void updateCurvatureCenter();
    void drawPauseScreen();

    int selectAutodestroyTarget();
    void autodestroyTarget();

    void printSnakes();
};

#endif
