#include "World.h"
#include "Tunnel.h"
#include <iostream>
using namespace std;

Tunnel::Tunnel() { 
    this->axis = new float[3]; 
}

void Tunnel::setFields(int * vertices, float radiusE, float radiusI)
{
    // put the barycenter of vertices[0], vertices[1], vertices[2] in axis 
    for (int i=0; i<3;i++) this->axis[i] = 0;
    for (int i=0; i<3;i++)
        for (int j=0; j<3; j++)
            this->axis[j] += Sphere::verticesCoordonates[3 * vertices[i] + j];

    float norm = 0;
    for (int i=0; i<3; i++) norm += this->axis[i]*this->axis[i];
    norm = sqrtf(norm);
    for (int i=0; i<3; i++) this->axis[i] = axis[i]/norm;

    this->radiusExt = radiusE;
    this->radiusInt = radiusI;
    this->radiusCurve = (radiusE - radiusI) / (radiusE + 1);

    this->xC = this->radiusInt + this->radiusCurve;
    float a = 1 - this->radiusCurve;
    this->yC = sqrtf(a*a - this->xC*this->xC);
}

Tunnel::~Tunnel(void)
{
    delete[] &axis;
}

void Tunnel::init(Tunnel * tunnels, float radiusE, float radiusI, World * w, int n)
{
    for (int i=0; i<20; i++) 
        tunnels[i].setFields(Sphere::faces[i].vertices, radiusE, radiusI);

    //int N = n;
    int bottomVertices[100];
    int nBottomVertices = 0;
    for(int i=0; i<n; i++)
        tunnels[0].projectOnTunnel(i, bottomVertices, nBottomVertices); //, n);
    //cout << nBottomVertices << " vertices fall into the hole." << endl;

    removeBottomFaces(Sphere::faces, bottomVertices, nBottomVertices); //, collec, nc, 4);
}

bool Tunnel::isBottomFace(Sphere::Triangle * face, int * bv, int nbv) //, int * collec, int & nc, int depth)
{
    if (!face) return false;
    int bottomVerticesCount = 0;
    //int bV1 = -1;
    //int bV2 = -1;
    for (int i=0; i<3; i++)
    {
        //int oldCount = bottomVerticesCount;
        for (int j=0; j<nbv; j++)
            if (bv[j] == face->vertices[i])                
            {
                bottomVerticesCount++;
                break;
            }
        //if (bottomVerticesCount == oldCount)
        //{
        //    if (bV1 == -1) bV1 = face->vertices[i];
        //    else bV2 = face->vertices[i];
        //}
    }

    //if (depth==0)
    //{
    //    if (bottomVerticesCount==1)
    //    {
    //        Tunnel::addBottomVertice(bV1, collec, nc);
    //        Tunnel::addBottomVertice(bV2, collec, nc);
    //    }
    //    if (bottomVerticesCount==2)
    //        Tunnel::addBottomVertice(bV1, collec, nc);
    //}
    if (bottomVerticesCount==3) return true;
    return false;
}

void Tunnel::addBottomVertice(int x, int * v, int & n)
{
    for (int i=0; i<n; i++)
        if (v[i] == x) return;
    v[n++] = x;
}

void Tunnel::removeBottomFaces(Sphere::Triangle * face, int * bv, int nbv) //, int * collec, int & nc, int depth)
{
    if (face && face->subTriangles)
        for (int i=0; i<4; i++)
        {
            if (isBottomFace(face->subTriangles[i], bv, nbv)) //, collec, nc, depth))
                face->subTriangles[i] = NULL;
            else
                removeBottomFaces(face->subTriangles[i], bv, nbv); //, collec, nc, depth-1);
        }
}

void Tunnel::sortCylinderVertices(int * index, int * bv, int nbv)
{
    for (int i=0; i<nbv; i++) index[i] = i;

    for (int i=1; i<nbv; i++)
    {
        int closest = Tunnel::closestVertice(index[i-1], index, i, bv, nbv);
        int temp = index[i];
        index[i] = index[closest];
        index[closest] = temp;
    }

    //for (int i=0; i<nbv; i++) 
    //    cout << i << ": " << index[i] << " -> " << bv[index[i]] 
    //         << " (x = " << bv[index[i]][0] << ")" << endl;
}

void Tunnel::sortCylinderVertices(int * v, int n)
{
    for (int i=0; i<n-2; i++)
    {
        float d_min = 9;
        int closestVertice = 0;
        for (int j=i+1; j<n; j++)
        {
            float d = 0;
            for (int k=0; k<3; k++)
            {
                float dd = Sphere::verticesCoordonates[3*v[i]+k]
                         - Sphere::verticesCoordonates[3*v[j]+k];
                d += dd * dd;
            }
            if (d < d_min)
            {
                d_min = d;
                closestVertice = j;
            }
        }
        //cout << d_min << endl;
        int temp = v[i+1];
        v[i+1] = v[closestVertice];
        v[closestVertice] = temp;
    }
}

int Tunnel::closestVertice(int i, int * index, int j, int * bv, int nbv)
{
    int closest = 0;
    float distance = 9;
    for (int k=j; k<nbv; k++)
    {
        float d = 0;
        float dd = 0;
        for (int l=0; l<3; l++)
        {
            dd = Sphere::verticesCoordonates[3 * bv[index[k]] + l] 
                -Sphere::verticesCoordonates[3 * bv[i] + l];
            d += dd*dd;
        }
        if (d<distance)
        {
            distance = d;
            closest = k;
        }
    }
    return closest;
}


Tunnel::position Tunnel::toLocalCoordonates(float * q, float & xQ, float & yQ)
    // does not modify q
{
    yQ = 0; // yQ is q .scal axis
    for (int i=0; i<3; i++) yQ += q[i]*this->axis[i];

    xQ = 0;
    for (int i=0; i<3; i++)
    {
        float dxQ = q[i] - yQ * this->axis[i];
        xQ += dxQ * dxQ;
    }
    xQ = sqrtf(xQ);

    if (xQ > this->radiusExt) return Tunnel::Out;
    if (xQ < this->radiusInt) return Tunnel::In;
    return Tunnel::On;
}

void Tunnel::localNormal(float * q, float xQ, float yQ, float * n)
{
    float nn = 0;
    for (int i=0; i<3; i++)
    {
        // local center coordonate
        n[i] = yC * this->axis[i] + xC * (q[i] - yQ*this->axis[i]) / xQ;
        // normal = radius = projection of q on local sphere - local center 
        n[i] = q[i] - n[i];
        nn += n[i] * n[i];
    }
    nn = sqrtf(nn);
    for (int i = 0; i < 3; i++) n[i] /= nn;
}

void Tunnel::projectOnTunnel(int index, int * bv, int & nbv) //, int & v)
{
    float * q = Sphere::verticesCoordonates + 3*index;
    float * n = Sphere::normalsCoordonates + 3*index;
    float xQ, yQ, yP, nn, A, B;
    float c[3];
    switch (this->toLocalCoordonates(q, xQ, yQ))
    {
    case (Tunnel::On):
        // compute yP of the projection P of Q onto the tunnel 
        // in the direction of -axis
        yP = xQ - this->xC; // used as temp
        yP = this->yC + sqrtf(this->radiusCurve*this->radiusCurve - yP*yP);
        for (int k=0; k<3; k++) q[k] += (yP-yQ)*this->axis[k];
        this->localNormal(q, xQ, yQ, n);

        if (xQ>(this->radiusInt + this->radiusExt)/2)
        {
            Sphere::colorCoordonates[index] = 0;
        }
        else
        {
            A = 0.5f/((1-WHERE_THE_INTERPOLATION_STARTS)*(this->radiusInt - this->radiusExt));
            B = - A*(WHERE_THE_INTERPOLATION_STARTS*this->radiusInt 
                + (1-WHERE_THE_INTERPOLATION_STARTS)*this->radiusExt);
            Sphere::colorCoordonates[index] = A * xQ + B;
        }
        break;
    case (Tunnel::In):
        if (xQ>0.0000001)
        {
            nn = 0;
            for (int i=0; i<3; i++)
            {
                n[i] = q[i] - yQ*this->axis[i];
                c[i] = this->yC * this->axis[i] + this->xC * n[i] / xQ;
                nn += n[i] * n[i];
            }
            nn = sqrtf(nn);
            for (int i=0; i<3; i++) n[i] /= -nn;
            for (int i=0; i<3; i++) q[i] = /*0.96f */ this->yC * this->axis[i] - 1.01f * this->radiusInt*n[i];

            Tunnel::addBottomVertice((int)(q - Sphere::verticesCoordonates)/3, bv, nbv);
            Sphere::colorCoordonates[index] = 0.5;
        }
        break;
    default:
        // normalize q
        yQ = sqrtf(q[0]*q[0]+q[1]*q[1]+q[2]*q[2]);
        for (int i=0; i<3; i++) q[i] /= yQ;
        // make n be q (normals to the sphere are radial)
        for (int k=0; k<3; k++) n[k] = q[k];
        Sphere::colorCoordonates[index] = 0;
        break;
    }
}

void Tunnel::projectOnTunnelD(World * w)
{
    float * q = w->p;
    float * n = w->top;
    float * t = w->t;
    float xQ, yQ;

    yQ = 0; // yQ is q .scal axis
    for (int i=0; i<3; i++) yQ += q[i]*this->axis[i];

    // ATTENTION - this is where you switch planet (the JUMP)
    if (yQ <= this->yC)
    {
        for (int i=0; i<3; i++)
        {
            q[i] -= 2* this->yC * this->axis[i]; //-1.5412f*this->axis[i]; // 2*(this->yC - yQ)*this->axis[i];
            //t[i] = -t[i];
        }

        #ifdef TRACE_PLANET_JUMPS
        cout << "going from planet " << w->currentPlanet << " to planet ";
        int oldFaceId = w->currentFace;
        #endif
        w->currentPlanet = w->tunnelConnections[20 * w->currentPlanet + w->currentFace];
        w->currentFace = Planet::oppositeTunnels[w->currentFace];
        #ifdef TRACE_PLANET_JUMPS
        cout << w->currentPlanet << " through tunnel " << oldFaceId << "->" << w->currentFace << endl;
        #endif
        
        float * translate = new float[3];
        for (int i=0; i<3; i++) translate[i] = w->planets[w->currentPlanet]->position[i];
        for (int i=0; i<NUMBER_OF_PLANETS; i++)
            for (int j=0; j<3; j++)
                w->planets[i]->position[j] -= translate[j];
        delete[] translate;

        // recursive call
        Planet::tunnels[w->currentFace].projectOnTunnelD(w);
        
        #ifdef TRACE_PLANET_IN_ZERO
        for (int i=0; i<NUMBER_OF_PLANETS; i++)
            if (w->planets[i]->position[0]==0 && w->planets[i]->position[1]==0 
                && w->planets[i]->position[2]==0
                && i != w->currentPlanet)
            cout << "ERROR - planet " << i << " is in (0,0,0) but current planet is "
                 << w->currentPlanet << endl;
        if (!(w->planets[w->currentPlanet]->position[0]==0 
                && w->planets[w->currentPlanet]->position[1]==0 
                && w->planets[w->currentPlanet]->position[2]==0))
                cout << "ERROR - current planet " << w->currentPlanet << "is in ("
                     << w->planets[w->currentPlanet]->position[0] << ", "
                     << w->planets[w->currentPlanet]->position[1] << ", "
                     << w->planets[w->currentPlanet]->position[2] << ")" << endl;
        #endif

        w->playSound(SOUND_SPACE_JUMP, MY_SDL_MIX_MAXVOLUME);
        return;
    }

    xQ = 0;
    for (int i=0; i<3; i++)
    {
        float dxQ = q[i] - yQ * this->axis[i];
        xQ += dxQ * dxQ;
    }
    xQ = sqrtf(xQ);

    Tunnel::position pos;
    if (xQ > this->radiusExt || Planet::oppositeTunnels[w->currentFace] == -1) pos = Tunnel::Out;
    else if (yQ <= this->yC) pos = Tunnel::In;
    else pos = Tunnel::On;

    float A, B, K;
    float nn = 0;
    float c[3];
    switch (pos)
    {
    case (Tunnel::On):
    case (Tunnel::In):
        // compute yP of the projection P of Q onto the tunnel 
        // in the direction of QC (towards the curvature center)
  
        // local curvature center coordonates
        for (int i=0; i<3; i++)
        {
            c[i] = yC * this->axis[i] + xC * (q[i] - yQ*this->axis[i]) / xQ;
            n[i] = q[i] - c[i];
            nn += n[i] * n[i];
        }
        nn = sqrtf(nn);
        for (int i=0; i<3; i++) n[i] /= nn;
        for (int i=0; i<3; i++) q[i] = c[i] + this->radiusCurve*n[i];

        nn = t[0]*this->axis[0]+t[1]*this->axis[1]+t[2]*this->axis[2];
        if (nn<0) nn = -nn;
        yQ = q[0]*q[0]+q[1]*q[1]+q[2]*q[2];

        //A = 0.05f;
        //B = 0.010f * (3 - 2*nn*nn);
        //K = 1 - this->radiusCurve;
        //K *= K;

        A = DISTANCE_UPON_CAMERA;
        B = DISTANCE_UPON_CAMERA_INHOLE * (3 - /*2*/nn*nn);
        K = 1 - this->radiusCurve;
        K *= K;

        w->closeTop = (A-B)/(1-K) * yQ + (K*A-B)/(K-1);

        //A = 0.15f;
        //B = 0.045f * (1+nn);

        A = DISTANCE_BEHIND_CAMERA;
        B = DISTANCE_BEHIND_CAMERA_INHOLE * (1.8f+0.7f*nn);
        w->closeBehind = (A-B)/(1-K) * yQ + (K*A-B)/(K-1);
        
        // make t (tangeant) be normal to n (normal)
        xQ = t[0]*n[0]+t[1]*n[1]+t[2]*n[2];
        for (int i=0; i<3; i++) t[i] -= xQ*n[i];

        // mapTop: take (t+n) and make it be orthogonal to q
        for (int i=0; i<3; i++) w->mapTop[i] = t[i]+n[i];
        // at this point yQ is the square norm of Q
        xQ = 0;
        for (int i=0; i<3; i++) xQ += w->mapTop[i]*q[i];
        xQ /= yQ;
        // null the tangent composant of mt
        for (int i=0; i<3; i++) w->mapTop[i] -= xQ*q[i];

        w->onTunnel = true;
        break;
    default: // Out
        // normalize q
        yQ = 1.0f / sqrtf(q[0]*q[0]+q[1]*q[1]+q[2]*q[2]);
        for (int i=0; i<3; i++) q[i] *= yQ;
        // make n be q (normals to the sphere are radial)
        for (int k=0; k<3; k++) n[k] = q[k];

        //w->closeTop = 0.05f;
        //w->closeBehind = 0.15f;

        w->closeTop = DISTANCE_UPON_CAMERA;
        w->closeBehind = DISTANCE_BEHIND_CAMERA;

        // make t (tangeant) be normal to n (normal)
        xQ = t[0]*n[0]+t[1]*n[1]+t[2]*n[2];
        for (int i=0; i<3; i++) t[i] -= xQ*n[i];

        // mapTop: take t
        for (int i=0; i<3; i++) w->mapTop[i] = t[i];

        w->onTunnel = false;
        break;
    }

    nn = q[0]*t[0]+q[1]*t[1]+q[2]*t[2];
    #ifdef TRACE_LOOKING_DOWN
    if (w->lookingDown != (nn < -0.4f))
    {
        if (w->lookingDown)
            cout << "changing view direction from down to up" << endl;
        else
            cout << "changing view direction from up to down" << endl;
    }
    #endif
    w->lookingDown = (nn < -0.4f && Planet::oppositeTunnels[w->currentFace] != -1);
}

//Tunnel::position Tunnel::respectivePosition(float * p)
//{
//    // copy p in q and normalize q
//    float q[3];
//    float norm = sqrt((float) p[0]*p[0]+p[1]*p[1]+p[2]*p[2]);
//    for (int i=0; i<3; i++) q[i] = p[i]/norm;
//
//    // compute the distance "norm" between the current position and the axis of the tunnel
//    // scal is the length of the projection of q on ta
//    // na is the projection of q on the plan normal to ta
//    float scal = this->axis[0]*q[0]+this->axis[1]*q[1]+this->axis[2]*q[2];
//    float na[3];
//    for (int i=0; i<3; i++) na[i] = q[i] - scal*this->axis[i];
//    norm = sqrtf(na[0]*na[0]+na[1]*na[1]+na[2]*na[2]);
//
//    if (norm > this->radiusExt) return Out;
//    if (norm < this->radiusInt) return In;
//    return On;
//}

//int Tunnel::countVerticesToMove()
//{
//    int count = 0;
//
//    float x, y;
//    for(float * vertice = Sphere::verticesCoordonates;
//        vertice<Sphere::verticesCoordonates + 3*Sphere::numberOfVertices; 
//        vertice = vertice+3)
//    {
//        if (this->toLocalCoordonates(vertice, x, y)
//            && x > this->radiusInt)
//            count ++;
//    }
//
//    return count;
//}

//void Tunnel::projectOnTunnel(int i, int & j, float ** verticeMap, float * r)
//{
//    float * q = Sphere::verticesCoordonates + 3*i;
//    float xQ, yQ;
//    if (this->toLocalCoordonates(q, xQ, yQ))
//    {
//        // compute yP of the projection P of Q onto the tunnel 
//        // in the direction of -axis
//        float yP = 0;
//        if (xQ > this->radiusInt)
//        {
//            yP = xQ - this->xC; // used as temp
//            yP = this->yC + sqrtf(this->radiusCurve*this->radiusCurve - yP*yP);
//
//            verticeMap[i] = this->verticesCoordonates + j;
//            
//            for (int k=0; k<3; k++)
//                this->verticesCoordonates[j++] = q[k] + (yP-yQ)*this->axis[k];
//        }
//        else
//        {
//            verticeMap[i] = r;
//        }
//    }
//    else
//    {
//        verticeMap[i] = NULL;
//    }
//}
//
//void Tunnel::remapFace(Sphere::Triangle * face, float ** verticeMap, float * r)
//{
//    bool on = false;
//    bool in = false;
//    for (int k=0; k<3; k++)
//    {
//        float * m = 
//            verticeMap[(face->vertices[k] - Sphere::verticesCoordonates)/3];
//
//        if (m != NULL)
//        {
//            if (m == r) in = true;
//            else 
//            {
//                face->vertices[k] = m;
//            };
//        }
//    }
//
//    if (face->subTriangles != NULL)
//        for (int i=0; i<4; i++)
//            this->remapFace(face->subTriangles + i, verticeMap, r);
//}