#include "World.h"
#include "Tunnel.h"

Target::Target(float x, float y, float z, float xt, float yt, float zt, int pl, World * w)
: Star(INITIAL_EXT_RADIUS_TARGETS, x, y, z, xt, yt, zt, pl, w)
{
    this->isAlive = true;
    this->autoDestroyed = false;
    this->explosionFactor = 0;
    this->smokeFactor = 0;
    this->spikiness = INITIAL_SPIKINESS;
    this->dq = INITIAL_TARGET_SPEED;
    
    this->c1[0] = 1;
    this->c1[1] = 0.4f;
    this->c1[2] = 0;
    this->c2[0] = 0.2f;
    this->c2[1] = 0.8f;
    this->c2[2] = 0.2f;

    this->update(w);
}

Target::~Target(void)
{
}

//void Target::print(int i)
//{
//    cout << "Target " << i << " on face " << this->face << " of planet " << this->planet << " in ("
//        << this->q[0] << ", " << this->q[1] << ", " << this->q[2] << ") facing (" 
//        << this->t[0] << ", " << this->t[1] << ", " << this->t[2] << ")" << endl; 
//}

bool Target::isAtImpact(World * w)
{
    if (!this->isAlive) return false;
    if (this->planet != w->currentPlanet) return false;
    if (this->explosionFactor != 0) return false;
    if (this->smokeFactor != 0) return false;

    float d = 0;
    for (int i=0; i<3; i++)
    {
        float dd = this->q[i] - w->p[i];
        d += dd*dd;
    }
    float R = this->radius + w->player->radius;
    if (d > R*R) return false;

    return true;
}

void Target::explode(World * w)
{
    if (!this->isAlive) return;

    //cout << "target " << this << " exploded" << endl;
    if (this->explosionFactor == 0)
    {
        this->explosionFactor = 30;
    }
}

void Target::smoke(World * w)
{
    if (!this->isAlive) return;

    //cout << "target " << this << " exploded" << endl;
    if (this->smokeFactor == 0)
        this->smokeFactor = 15;
}

void Target::update(World * w)
{
    if (this->smokeFactor == 1)
    {
        this->isAlive = false;
        w->numberOfAliveTargets--;
        if (!w->numberOfAliveTargets) w->gameIsOver = 1;
        return;
    }

    (void) this->move(w);

    if (this->explosionFactor != 0)
    {
        this->explosionFactor--;
    }

    if (this->smokeFactor != 0)
    {
        this->smokeFactor--;
        this->dq /= 2;
    }

    if (this->spikiness != INITIAL_SPIKINESS)
    {
        if (this->spikiness <= SPIKINESS_AFTER_EXPLOSION + DELTA_SPIKINESS_WHEN_EXPLOSION)
        {
            if (this->spikiness % 5 == 0)
                w->mines[Mine::selectNextMine(w)]->reset(w, this->q, this->n, this->planet, this->face);

            float newRadius = 1.0f + 0.7f*(-SPIKINESS_AFTER_EXPLOSION 
                - DELTA_SPIKINESS_WHEN_EXPLOSION + this->spikiness)/DELTA_SPIKINESS_WHEN_EXPLOSION;
            if (this->radiusInt < newRadius)
                this->radiusInt = newRadius;
        }
        this->spikiness++;
        if (this->spikiness > 0)
        {
            this->radiusInt = 1.0f - 0.7f*this->spikiness/INITIAL_SPIKINESS;
        }
    }
}

void Target::draw(World * w)
{   
    glPushMatrix();

    glColor3f(1, 1, 1);

    glTranslatef(this->position[0], this->position[1], this->position[2]);
    if (this->planet == w->currentPlanet)
    {

        glRotatef(this->angle, w->v[0], w->v[1], w->v[2]);

        float mainRadius = this->radius * (1.5f - this->radiusInt);
        glScalef(mainRadius,mainRadius,mainRadius);
    }
    else
    {
    //    glTranslatef(1.02f*this->position[0], 1.02f*this->position[1], 1.02f*this->position[2]);

        glRotatef(this->angle, w->v[0], w->v[1], w->v[2]);

        float mainRadius = 1.5f * (this->radius * (1.5f - this->radiusInt));
        glScalef(mainRadius,mainRadius,mainRadius);
    }

    if (w->wire)
    {
        if (this->smokeFactor == 0)
        {
            glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
            this->drawHelperW(w, this->c1, this->c2);
            glPopMatrix();
            glPushMatrix();
            if (this->explosionFactor > 15)
            {
                glTranslatef(w->front[0], w->front[1], w->front[2]);
                float mainRadius = 1.5f * (this->radius * (1.5f - this->radiusInt));
                glScalef(mainRadius,mainRadius,mainRadius);
                this->drawExplosionW(w, 1, 1, 1, 5 - ((float)this->explosionFactor-15)/3);
            }
        }
        else
        {
            this->drawExplosionW(w, 1, 1, 1, 5 - ((float)this->smokeFactor)/3);
        }
    }
    else
    {
        if (this->smokeFactor == 0)
        {
            glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
            this->drawHelper(w, this->c1, this->c2);
            glPopMatrix();
            glPushMatrix();
            if (this->explosionFactor > 15)
            {
                glTranslatef(w->front[0], w->front[1], w->front[2]);
                float mainRadius = 1.5f * (this->radius * (1.5f - this->radiusInt));
                glScalef(mainRadius,mainRadius,mainRadius);
                this->drawExplosion(w, 1, 1, 1, 5 - ((float)this->explosionFactor-15)/3, 
                    ((float)this->explosionFactor-15)/12, w->fireTextureId);
            }
        }
        else
        {
            this->drawExplosion(w, 1, 1, 1, 5 - ((float)this->smokeFactor)/3, 
                ((float)this->smokeFactor)/12, w->smokeTextureId);
        }
    }
    glPopMatrix();
}