#ifndef STAR_H_
#define STAR_H_

#include "Sphere.h"

class Star :
    public Sphere
{
public:
    Star(float r);
    Star(float r, float x, float y, float z, float xt, float yt, float zt, int pl, World * w);
    //Star(float r, float x, float y, float z);
    ~Star(void);
    
    virtual void draw(World * w) = 0;
    virtual void drawHelper(World * w, float * c1, float * c2);
    virtual void drawHelperW(World * w, float * c1, float * c2);
    static void drawExplosion(World * w, float c1, float c2, float c3, 
        float scaleFactor, float blendFactor, GLuint textureId);
    static void drawExplosionW(World * w, float c1, float c2, float c3, float scaleFactor);
    virtual void update(World * w) = 0;
    bool move(World * w);

    int planet, face;
    float * position;
    float q[3], t[3], v[3], tr[3], n[3];
    float radius;
    float radiusInt;
    float angle;
    float colorCoord, dq;
    static float A, B;
    static float * textureCoordonates;

    float c1[4], c2[4];
};

#endif