#include "Star.h"
#include "Planet.h"
#include "Tunnel.h"
#include "World.h"

float * Star::textureCoordonates = NULL;
float Star::A = 0;
float Star::B = 0;

Star::Star(float r)
{
    this->radius = r;
    this->position = new float[3];
    this->angle = 30;
    this->radiusInt = 0.3f;
    this->c1[3] = 1;
    this->c2[3] = 1;
}

Star::Star(float r, float x, float y, float z, float xt, float yt, float zt, int pl, World * w)
{
    this->radius = r;
    this->position = new float[3];
    this->angle = 30;
    this->radiusInt = 0.3f;
    
    float n = sqrtf(x*x+y*y+z*z);
    this->planet = pl;
    this->face = 0;
    this->q[0] = x/n;
    this->q[1] = y/n;
    this->q[2] = z/n;
    this->t[0] = xt;
    this->t[1] = yt;
    this->t[2] = zt;

    this->c1[3] = 1;
    this->c2[3] = 1;

    // make t (tangeant) be normal to q (normal)
    n = this->t[0]*this->q[0]+this->t[1]*this->q[1]+this->t[2]*this->q[2];
    for (int i=0; i<3; i++) this->t[i] -= n*this->q[i];
    n = sqrtf(this->t[0]*this->t[0]+this->t[1]*this->t[1]+this->t[2]*this->t[2]);
    for (int i=0; i<3; i++) this->t[i] /= n;
    
    if (Star::textureCoordonates == NULL)
    {
        Star::textureCoordonates = new float[12];
        Star::textureCoordonates[0]  = 0;
        Star::textureCoordonates[1]  = 0;
        Star::textureCoordonates[2]  = 1;
        Star::textureCoordonates[3]  = 0;
        Star::textureCoordonates[4]  = 0.5f;
        Star::textureCoordonates[5]  = 0.866025404f;
        Star::textureCoordonates[6]  = 0.5f;
        Star::textureCoordonates[7]  = 0;
        Star::textureCoordonates[8]  = 0.75f;
        Star::textureCoordonates[9]  = 0.433012702f;
        Star::textureCoordonates[10] = 0.25f;
        Star::textureCoordonates[11] = 0.433012702f;

        Tunnel * tun = w->planets[0]->tunnels;
        Star::A = 0.5f/((1-WHERE_THE_INTERPOLATION_STARTS)*(tun->radiusInt - tun->radiusExt));
        Star::B = - A*(WHERE_THE_INTERPOLATION_STARTS*tun->radiusInt 
            + (1-WHERE_THE_INTERPOLATION_STARTS)*tun->radiusExt);
    }
}

//Star::Star(float r, float x, float y, float z)
//{
//    this->radius = r;
//    this->position = new float[3];
//    this->position[0] = x;
//    this->position[1] = y;
//    this->position[2] = z;
//}
//
//Star::Star(float r, float * p)
//{
//    this->radius = r;
//    this->position = p;
//}

Star::~Star(void)
{
}

bool Star::move(World * w)
{
    bool switchPlanet = false;

    this->face = Planet::getCurrentFace(this->q, this->face);
    Tunnel * tun = Planet::tunnels + this->face;
    float xQ, yQ;

    yQ = 0; // yQ is q .scal axis
    for (int i=0; i<3; i++) yQ += this->q[i]*tun->axis[i];

    // ATTENTION - this is where you switch planet (the JUMP)
    if (yQ <= tun->yC && Planet::oppositeTunnels[this->face] != -1)
    {
        switchPlanet = true;

        for (int i=0; i<3; i++) 
        {
            this->tr[i] = 2* tun->yC * tun->axis[i];
            this->q[i] -= this->tr[i];
        }

        this->planet = w->tunnelConnections[20 * this->planet + this->face];
        this->face = Planet::oppositeTunnels[this->face];

        // reinitialize the variables so we can continue without a recursive call
        tun = Planet::tunnels + this->face;
        yQ = 0;
        for (int i=0; i<3; i++) yQ += this->q[i]*tun->axis[i];
    }

    xQ = 0;
    for (int i=0; i<3; i++)
    {
        float dxQ = this->q[i] - yQ * tun->axis[i];
        xQ += dxQ * dxQ;
    }
    xQ = sqrtf(xQ);

    if (xQ <= tun->radiusExt && Planet::oppositeTunnels[this->face] != -1)
    {
        this->colorCoord = this->A * xQ + this->B;

        float nn = 0;
        float c[3];
        // compute yP of the projection P of Q onto the tunnel 
        // in the direction of QC (towards the curvature center)
  
        // local curvature center coordonates
        for (int i=0; i<3; i++)
        {
            c[i] = tun->yC * tun->axis[i] + tun->xC * (this->q[i] - yQ*tun->axis[i]) / xQ;
            this->n[i] = this->q[i] - c[i];
            nn += this->n[i] * this->n[i];
        }
        nn = sqrtf(nn);
        for (int i=0; i<3; i++) 
        {
            this->n[i] /= nn;
            this->q[i] = c[i] + tun->radiusCurve*this->n[i];
        }

        //nn = this->t[0]*tun->axis[0]+this->t[1]*tun->axis[1]+this->t[2]*tun->axis[2];
        //if (nn<0) nn = -nn;
        //yQ = this->q[0]*this->q[0]+this->q[1]*this->q[1]+this->q[2]*this->q[2];

        // make t (tangeant) be normal to n (normal)
        xQ = this->t[0]*this->n[0]+this->t[1]*this->n[1]+this->t[2]*this->n[2];
        for (int i=0; i<3; i++) this->t[i] -= xQ*n[i];
        nn = sqrtf(this->t[0]*this->t[0] + this->t[1]*this->t[1] + this->t[2]*this->t[2]);
        for (int i=0; i<3; i++) this->t[i] /= nn;

        for (int i=0; i<3; i++)
            this->position[i] = this->q[i] + this->radius * (1.5f - this->radiusInt) * 0.9f*this->n[i];

        this->v[0] = this->n[1]*this->t[2]-this->n[2]*this->t[1];
        this->v[1] = this->n[2]*this->t[0]-this->n[0]*this->t[2];
        this->v[2] = this->n[0]*this->t[1]-this->n[1]*this->t[0];
    }
    else
    {
        this->colorCoord = 0;

        // normalize q
        yQ = sqrtf(this->q[0]*this->q[0]+this->q[1]*this->q[1]+this->q[2]*this->q[2]);
        for (int i=0; i<3; i++) this->q[i] /= yQ;

        // make n be q
        for (int i=0; i<3; i++) this->n[i] = this->q[i];

        // make t (tangeant) be normal to n (normal)
        xQ = this->t[0]*this->q[0]+this->t[1]*this->q[1]+this->t[2]*this->q[2];
        for (int i=0; i<3; i++) this->t[i] -= xQ*this->q[i];
        float nn = sqrtf(this->t[0]*this->t[0] + this->t[1]*this->t[1] + this->t[2]*this->t[2]);
        for (int i=0; i<3; i++) this->t[i] /= nn;

        for (int i=0; i<3; i++)
            this->position[i] = (1 + this->radius * (1.5f - this->radiusInt) * 0.9f) * this->q[i];

        this->v[0] = this->q[1]*this->t[2]-this->q[2]*this->t[1];
        this->v[1] = this->q[2]*this->t[0]-this->q[0]*this->t[2];
        this->v[2] = this->q[0]*this->t[1]-this->q[1]*this->t[0];
    }

    for (int i=0; i<3; i++) this->q[i] += this->dq * this->t[i];
    
    this->angle += 20;

    return switchPlanet;
}

void Star::drawHelper(World * w, float * c1, float * c2) // involves no geometric transformation
{
    glFrontFace(GL_CCW);
    glDisable(GL_CULL_FACE);
    glEnable(GL_NORMALIZE);

    glBegin(GL_TRIANGLES);
    float * faceVertices = new float[12];
    for (int i=0; i<20; i++) // each of the 20 faces
    {
        glColor4fv(c1);
        for (int k=0; k<3; k++) // each of the 3 outside triangles
        {
            int * vertice = Sphere::faces[i].subTriangles[k]->vertices;

            for (int l=0; l<3; l++) // each of the three coordonates of the first vertice
            {
                faceVertices[l] = Sphere::verticesCoordonates[3 * vertice[0] + l];
            }
            for (int j=1; j<3; j++) // each of the last two vertices
            {
                for (int l=0; l<3; l++) // each of the three coordonates
                {
                    faceVertices[3*j+l] = this->radiusInt * Sphere::verticesCoordonates[3 * vertice[j] + l];
                }
            }

            // the normal is the vect product of two support vectors, -02-> and -01->
            if (this->radiusInt != 1)
            {
                for (int j=0; j<3; j++) 
                    faceVertices[9+j] = (faceVertices[6 + ((j+1)%3)] - faceVertices[(j+1)%3])
                                    * (faceVertices[3 + ((j+2)%3)] - faceVertices[(j+2)%3])
                                    - (faceVertices[6 + ((j+2)%3)] - faceVertices[(j+2)%3])
                                    * (faceVertices[3 + ((j+1)%3)] - faceVertices[(j+1)%3]);
            }
            else
            {
                for (int j=0; j<3; j++) 
                    faceVertices[9+j] = faceVertices[j];
            }

            glNormal3fv(faceVertices+9);
            glVertex3fv(faceVertices);
            glVertex3fv(faceVertices+3);
            glVertex3fv(faceVertices+6);
        }

        // the fourth, middle triangle
        glColor4fv(c2);

        int * vertice = Sphere::faces[i].subTriangles[3]->vertices;

        for (int j=0; j<3; j++) // each of the three vertices
        {
            for (int l=0; l<3; l++) // each of the three coordonates
            {
                faceVertices[3*j+l] = this->radiusInt * Sphere::verticesCoordonates[3 * vertice[j] + l];
            }
        }

        // the normal is the vect product of two support vectors, -02-> and -01->
        for (int j=0; j<3; j++) 
            faceVertices[9+j] = (faceVertices[6 + ((j+1)%3)] - faceVertices[(j+1)%3])
                                * (faceVertices[3 + ((j+2)%3)] - faceVertices[(j+2)%3])
                                - (faceVertices[6 + ((j+2)%3)] - faceVertices[(j+2)%3])
                                * (faceVertices[3 + ((j+1)%3)] - faceVertices[(j+1)%3]);

        glNormal3fv(faceVertices+9);
        glVertex3fv(faceVertices);
        glVertex3fv(faceVertices+3);
        glVertex3fv(faceVertices+6);
    }
    delete [] faceVertices;
    glEnd();

    glDisable(GL_NORMALIZE);
}

void Star::drawHelperW(World * w, float * c1, float * c2) // involves no geometric transformation
{
    glLineWidth(3);
    glFrontFace(GL_CCW);
    glDisable(GL_CULL_FACE);
    glEnable(GL_NORMALIZE);

    float * faceVertices = new float[12];
    for (int i=0; i<20; i++) // each of the 20 faces
    {
        glColor4fv(c1);
        for (int k=0; k<3; k++) // each of the 3 outside triangles
        {
            int * vertice = Sphere::faces[i].subTriangles[k]->vertices;

            for (int l=0; l<3; l++) // each of the three coordonates of the first vertice
            {
                faceVertices[l] = Sphere::verticesCoordonates[3 * vertice[0] + l];
            }
            for (int j=1; j<3; j++) // each of the last two vertices
            {
                for (int l=0; l<3; l++) // each of the three coordonates
                {
                    faceVertices[3*j+l] = this->radiusInt * Sphere::verticesCoordonates[3 * vertice[j] + l];
                }
            }

            // the normal is the vect product of two support vectors, -02-> and -01->
            if (this->radiusInt != 1)
            {
                for (int j=0; j<3; j++) 
                    faceVertices[9+j] = (faceVertices[6 + ((j+1)%3)] - faceVertices[(j+1)%3])
                                    * (faceVertices[3 + ((j+2)%3)] - faceVertices[(j+2)%3])
                                    - (faceVertices[6 + ((j+2)%3)] - faceVertices[(j+2)%3])
                                    * (faceVertices[3 + ((j+1)%3)] - faceVertices[(j+1)%3]);
            }
            else
            {
                for (int j=0; j<3; j++) 
                    faceVertices[9+j] = faceVertices[j];
            }

            glBegin(GL_LINE_LOOP);
            glNormal3fv(faceVertices+9);
            glVertex3fv(faceVertices);
            glVertex3fv(faceVertices+3);
            glVertex3fv(faceVertices+6);
            glEnd();
        }

        // the fourth, middle triangle
        //glColor4fv(c2);

        int * vertice = Sphere::faces[i].subTriangles[3]->vertices;

        for (int j=0; j<3; j++) // each of the three vertices
        {
            for (int l=0; l<3; l++) // each of the three coordonates
            {
                faceVertices[3*j+l] = this->radiusInt * Sphere::verticesCoordonates[3 * vertice[j] + l];
            }
        }

        // the normal is the vect product of two support vectors, -02-> and -01->
        for (int j=0; j<3; j++) 
            faceVertices[9+j] = (faceVertices[6 + ((j+1)%3)] - faceVertices[(j+1)%3])
                                * (faceVertices[3 + ((j+2)%3)] - faceVertices[(j+2)%3])
                                - (faceVertices[6 + ((j+2)%3)] - faceVertices[(j+2)%3])
                                * (faceVertices[3 + ((j+1)%3)] - faceVertices[(j+1)%3]);

        glBegin(GL_LINE_LOOP);
        glNormal3fv(faceVertices+9);
        glVertex3fv(faceVertices);
        glVertex3fv(faceVertices+3);
        glVertex3fv(faceVertices+6);
        glEnd();
    }
    delete [] faceVertices;

    glDisable(GL_NORMALIZE);
    glLineWidth(1);
}

void Star::drawExplosion(World * w, float c1, float c2, float c3, float scaleFactor, float blendFactor, GLuint textureId)
{
    glEnable(GL_BLEND);
    glDisable(GL_CULL_FACE);
    glColor4f(c1, c2, c3, blendFactor);
    glBindTexture(GL_TEXTURE_2D, textureId);
    glScalef(scaleFactor, scaleFactor, scaleFactor);

    glBegin(GL_TRIANGLES);
    for (int i=0; i<20; i++)
    {
        for (int k=0; k<3; k++)
        {
            int * vertice = Sphere::faces[i].subTriangles[k]->vertices;

            glTexCoord2fv(Star::textureCoordonates + 2 * k);
            glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[0]);
            glTexCoord2fv(Star::textureCoordonates + 6 + 2 * k);
            glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[1]);
            glTexCoord2fv(Star::textureCoordonates + 6 + 2 * ((2 + k) % 3));
            glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[2]);
        }
        int * vertice = Sphere::faces[i].subTriangles[3]->vertices;

        for (int j=0; j<3; j++)
        {
            glTexCoord2fv(Star::textureCoordonates + 6 + 2 * j);
            glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[j]);
        }
    }
    glEnd();

    glDisable(GL_BLEND);
    glEnable(GL_CULL_FACE);
}

void Star::drawExplosionW(World * w, float c1, float c2, float c3, float scaleFactor)
{
    glLineWidth(3);
    glDisable(GL_CULL_FACE);
    glColor4f(c1, c2, c3, 1);
    glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
    glScalef(scaleFactor, scaleFactor, scaleFactor);

    for (int i=0; i<20; i++)
    {
        for (int k=0; k<3; k++)
        {
            int * vertice = Sphere::faces[i].subTriangles[k]->vertices;

            glBegin(GL_LINE_LOOP);
            glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[0]);
            glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[1]);
            glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[2]);
            glEnd();
        }
        int * vertice = Sphere::faces[i].subTriangles[3]->vertices;

        glBegin(GL_LINE_LOOP);
        for (int j=0; j<3; j++)
        {
            glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[j]);
        }
        glEnd();
    }

    glEnable(GL_CULL_FACE);
    glLineWidth(1);
}