#ifndef SPHERE_H_
#define SPHERE_H_

#define WIN32_LEAN_AND_MEAN

#include <stdlib.h>

#ifdef _WIN32
#include <windows.h>
#endif

#pragma comment(lib, "OpenGL32.lib")
#pragma comment(lib, "GlU32.lib")
#include <GL/gl.h>
#include <GL/glu.h>
#pragma comment(lib, "SDL.lib")
#pragma comment(lib, "SDLmain.lib")
#include <SDL.h>
#include "SDL_audio.h"
//#include "SDL_mixer.h"
#include <iostream>
#include <math.h>
using namespace std;

#define NUMBER_OF_EXTRUSIONS 5
#define NUMBER_OF_VERTICES 947
#define NUMBER_OF_PLANETS 6
#define NUMBER_OF_TARGETS 26
#define NUMBER_OF_SNAKES 15
#define NUMBER_OF_MINES 40
#define NUMBER_OF_MISSILES 30
#define TAIL_LENGTH 18
#define INITIAL_EXT_RADIUS_TARGETS 0.034f
#define INITIAL_INT_RADIUS_TARGETS 0.3f
#define INITIAL_SPIKINESS 30
#define SPIKINESS_AFTER_EXPLOSION -100
#define DELTA_SPIKINESS_WHEN_EXPLOSION 10
#define DISTANCE_BEHIND_CAMERA 0.13f
#define DISTANCE_UPON_CAMERA 0.12f
#define DISTANCE_BEHIND_VIEW_CENTER 0.08f
#define DISTANCE_UPON_CAMERA_INHOLE 0.04f
#define DISTANCE_BEHIND_CAMERA_INHOLE 0.055f
#define PLAYERS_MAX_SPEED_NORMAL 0.012f
#define PLAYERS_MAX_SPEED_SHIFT 0.04f
#define PLAYERS_MIN_SPEED_AFTER_BOUNCE 0.019f
#define INITIAL_MISSILE_SPEED 0.012f
#define INITIAL_TARGET_SPEED 0.009f
#define WHERE_THE_INTERPOLATION_STARTS 0.3f
#define TIME_LAPS_BETWEEN_TARGET_AUTODESTROY 30000
#define GAME_TITLE "The Deadly Soccer Ball"

#define NUMBER_OF_SOUNDS 11
#define NUMBER_OF_SOUNDS_P 5
#define SOUND_EXPLOSION_MISSILE 0
#define SOUND_SPACE_JUMP 1
#define SOUND_DRIVEBY 2
#define SOUND_MISSILE_LAUNCH 3
#define SOUND_EXPLOSION_MINE 4
#define SOUND_AUTODESTROY 5
#define SOUND_SMOKE 6
#define SOUND_SPIKE 7
#define SOUND_ACCELERATION 8
#define SOUND_BOING 9
#define SOUND_BOING2 10
//#define SOUND_GONG 67868

//#define TRACE_TUNNEL_CONNECTIONS
//#define TRACE_PLANET_JUMPS
//#define TRACE_FACE_JUMPS
//#define TRACE_LOOKING_DOWN
//#define TRACE_PLANET_IN_ZERO

class World;

class Sphere
{
public:
    Sphere(void);
    ~Sphere(void);

    static int init(World * w);

    struct Triangle
    {
        int vertices[3];
        Triangle * subTriangles[4];
    };

    static int numberOfVertices;
    static float * verticesCoordonates;
    static float * normalsCoordonates;
    static float * textureCoordonates1;
    static float * textureCoordonates2;
    static float * colorCoordonates;
    static Triangle * faces;

    virtual void draw(World * w) = 0;
    static void loadTexture(char * fileName, GLuint * tId);

protected:

    static void makeIcodahedronRotation(int faceNumber);
    void drawFace1(Triangle * p, int n, float * c);
    void drawFace2(Triangle * p, int n, float * c);
    void drawFaceW(Triangle * p, int n);
    void drawFace1(Triangle * p, int n, float * cExt, float * cInt);
    void drawFace2(Triangle * p, int n, float * cExt, float * cInt);
    void drawFaceW(Triangle * p, int n, float * cExt, float * cInt);

private:
    static float squareDistance(float * v, int i, int j);
    static float orientationSign(float * v, int * triangle);
    
    static void makeIsocaedre();
    static void extrudeTriangle(Triangle * p, int& v, int n);
    //static void copyTriangle(Triangle * origin, Triangle * dest, int n, int & v);
};

#endif