#include "Planet.h"

// static initialization of the static variables 
    int Sphere::numberOfVertices = NUMBER_OF_VERTICES;
    //for (int i = 0; i < 5; i++)
    //    Sphere::numberOfVertices = 4*Sphere::numberOfVertices - 6;
    float * Sphere::verticesCoordonates = new float[3*Sphere::numberOfVertices];
    float * Sphere::normalsCoordonates = new float[3*Sphere::numberOfVertices];
    float * Sphere::textureCoordonates1 = new float[2*Sphere::numberOfVertices];
    float * Sphere::textureCoordonates2 = new float[2*Sphere::numberOfVertices];
    float * Sphere::colorCoordonates = new float[Sphere::numberOfVertices];
    Sphere::Triangle * Sphere::faces = new Triangle[21]; // 20 faces + the punched face

float Sphere::squareDistance(float * v, int i, int j)
{
    float dx = v[3*i]-v[3*j];
    float dy = v[3*i+1]-v[3*j+1];
    float dz = v[3*i+2]-v[3*j+2];
    return dx*dx+dy*dy+dz*dz;
}

float Sphere::orientationSign(float * v, int * triangle)
{
    float * a = v + triangle[0];
    float * b = v + triangle[1];
    float * c = v + triangle[2];
    return ((b[0]-a[0])*(c[1]-a[1]) - (b[1]-a[1])*(c[0]-a[0]))*a[0]
         + ((b[1]-a[1])*(c[2]-a[2]) - (b[2]-a[2])*(c[1]-a[1]))*a[1]
         + ((b[2]-a[2])*(c[0]-a[0]) - (b[0]-a[0])*(c[2]-a[2]))*a[2];
}

void Sphere::makeIsocaedre()
{ 
    float t = (sqrt((float)5.)-1)/2;
    float r = sqrt((float)(1+t*t));
    int k=0;

    // compute the vertices' coordonates, in a unit sphere
    for (int i=0; i<2; i++)
    {
        for (int j=0; j<2; j++)
        {
            verticesCoordonates[k++] = 0;
            verticesCoordonates[k++] = ((float)(2*i-1))/r;
            verticesCoordonates[k++] = (2*j-1)*t/r;

            verticesCoordonates[k++] = ((float)(2*i-1))/r;
            verticesCoordonates[k++] = (2*j-1)*t/r;
            verticesCoordonates[k++] = 0;

            verticesCoordonates[k++] = (2*j-1)*t/r;
            verticesCoordonates[k++] = 0;
            verticesCoordonates[k++] = ((float)(2*i-1))/r;
        }
    }

    for (int i = 0; i < 60; i++)
        normalsCoordonates[i] = verticesCoordonates[i];

    // make the triangles by finding adjacent vertices
    int f = 0; // index of the next face to insert
    int * facesCount = new int[12];
    for (int i = 0; i < 12; i++) facesCount[i] = 0;
    int * adjacentVertices = new int[5];
    int * newFace = new int[3];

    // for each vertice i
    for (int i = 0; i < 11; i++)
        // if we haven't found the 5 adjacent triangles to i yet
        if (facesCount[i] < 5)
        {

            // find the 5 adjacent vertices of the vertice i
            int av=0;
            for (int j = 0; j < 12; j++)
                if (j != i && squareDistance(verticesCoordonates, i, j) < 2)
                    adjacentVertices[av++] = j;

            // for each of those vertices j
            for (int j = 0; j < 4; j++)
                // if we haven't found the 5 adjacent triangles to j yet
                if (facesCount[adjacentVertices[j]] < 5)
                    // for each other k adjacent to i and not tried yet
                    for (int k = j+1; k < 5; k++)
                        // if k is adjacent to j as well
                        if (squareDistance(verticesCoordonates, adjacentVertices[j], adjacentVertices[k]) < 2)
                        {
                            int jj = adjacentVertices[j];
                            int kk = adjacentVertices[k];

                            // make the first vertice be the minimum for uniqueness
                            if (i < jj && i < kk)
                            {
                                newFace[0] = i;
                                newFace[1] = jj;
                                newFace[2] = kk;
                            }
                            else if (jj < i && jj < kk)
                            {
                                newFace[0] = jj;
                                newFace[1] = i;
                                newFace[2] = kk;
                            }
                            else
                            {
                                newFace[0] = kk;
                                newFace[1] = jj;
                                newFace[2] = i;
                            }

                            // verify that the face's normal is oriented towards the center
                            if (orientationSign(verticesCoordonates, newFace) > 0)
                            {
                                int temp = newFace[1];
                                newFace[1] = newFace[2];
                                newFace[2] = temp;
                            }

                            // verify that this face hasn't been inserted yet
                            int isNewFace = 1;
                            for (int l = 0; l < f; l++)
                                if (Sphere::faces[l].vertices[0] == newFace[0]
                                 && Sphere::faces[l].vertices[1] == newFace[1]
                                 && Sphere::faces[l].vertices[2] == newFace[2])
                                 {
                                     isNewFace = 0;
                                     break;
                                 }

                            if (isNewFace) // insert face
                            {
                                for (int l=0; l<3; l++) 
                                {
                                    facesCount[newFace[l]]++;
                                    Sphere::faces[f].vertices[l] = newFace[l];
                                }
                                for (int l=0; l<4; l++)
                                    Sphere::faces[f].subTriangles[l] = NULL;
                                f++;
                            }
                        }
        }
    delete[] newFace;
    delete[] facesCount;
    delete[] adjacentVertices;
}

void Sphere::extrudeTriangle(Triangle * p, int& v, int n)
{
    if (n==0) return;

    int * newVerticeArray = new int[3];
    float * newVertice = new float[7]; // 3 coords + (2+2) texture coords
    for (int j = 0; j < 3; j++)
    {
        // coords interpolation
        for (int k = 0; k < 3; k++)
            newVertice[k] = Sphere::verticesCoordonates[3*p->vertices[j] + k]
                          + Sphere::verticesCoordonates[3*p->vertices[(j+1) % 3] + k];
        float norm = sqrtf(newVertice[0]*newVertice[0]
            + newVertice[1]*newVertice[1] + newVertice[2]*newVertice[2]);
        for (int k = 0; k < 3; k++) newVertice[k] /= norm;

        // texture intrepolation
        for (int k=0; k<2; k++)
        {
            newVertice[3+k] = 0.5f * (Sphere::textureCoordonates1[2*p->vertices[j] + k]
                            + Sphere::textureCoordonates1[2*p->vertices[(j+1) % 3] + k]);
            newVertice[5+k] = 0.5f * (Sphere::textureCoordonates2[2*p->vertices[j] + k]
                            + Sphere::textureCoordonates2[2*p->vertices[(j+1) % 3] + k]);
        }

        newVerticeArray[j] = -1;
        for (int k = 0; k < v; k++)
        {
            float * oldVertice = Sphere::verticesCoordonates + 3*k;
            if (newVertice[0] == oldVertice[0]
                && newVertice[1] == oldVertice[1]
                && newVertice[2] == oldVertice[2])
                {
                    newVerticeArray[j] = k;
                    break;
                }
        }
        if (newVerticeArray[j] == -1)
        {
            newVerticeArray[j] = v;
            for (int k = 0; k < 3; k++)
                Sphere::verticesCoordonates[3*v + k] = newVertice[k];
            for (int k = 0; k < 2; k++)
            {
                Sphere::textureCoordonates1[2*v + k] = newVertice[3+k];
                Sphere::textureCoordonates2[2*v + k] = newVertice[5+k];
            }
            v++;
        }
    }

    for (int k=0; k<4; k++)
        p->subTriangles[k] = new Triangle();
    p->subTriangles[0]->vertices[0] = p->vertices[0];
    p->subTriangles[0]->vertices[1] = newVerticeArray[0];
    p->subTriangles[0]->vertices[2] = newVerticeArray[2];
    p->subTriangles[1]->vertices[0] = p->vertices[1];
    p->subTriangles[1]->vertices[1] = newVerticeArray[1];
    p->subTriangles[1]->vertices[2] = newVerticeArray[0];
    p->subTriangles[2]->vertices[0] = p->vertices[2];
    p->subTriangles[2]->vertices[1] = newVerticeArray[2];
    p->subTriangles[2]->vertices[2] = newVerticeArray[1];
    p->subTriangles[3]->vertices[0] = newVerticeArray[0];
    p->subTriangles[3]->vertices[1] = newVerticeArray[1];
    p->subTriangles[3]->vertices[2] = newVerticeArray[2];

    for (int j = 0; j < 4; j++)
    {
        for (int k=0; k<4; k++)
            p->subTriangles[j]->subTriangles[k] = NULL;
        Sphere::extrudeTriangle(p->subTriangles[j], v, n-1);
    }

    delete[] newVertice;
    delete[] newVerticeArray;
}

//void Sphere::copyTriangle(Triangle * origin, Triangle * dest, int n, int & v)
//{
//    // copy the vertices
//    for (int i=0; i<3; i++)
//    {
//        int index = n + origin->vertices[i];
//        dest->vertices[i] = index;
//
//        if (index >= v)
//        {
//            for (int j=0; j<3; j++)
//            {
//                Sphere::verticesCoordonates[3*index + j] = 
//                    Sphere::verticesCoordonates[3*origin->vertices[i] + j];
//                Sphere::normalsCoordonates[3*index + j] = 
//                    Sphere::verticesCoordonates[3*index + j];
//            }
//            for (int j=0; j<2; j++)
//            {
//                Sphere::textureCoordonates1[2*index + j] = 
//                    Sphere::textureCoordonates1[2*origin->vertices[i] + j];
//                Sphere::textureCoordonates2[2*index + j] = 
//                    Sphere::textureCoordonates2[2*origin->vertices[i] + j];
//            }
//            Sphere::colorCoordonates[index + j] = 
//                Sphere::textureCoordonates1[origin->vertices[i] + j];
//
//            v++;
//        }
//    }
//
//    // recurse
//    for (int i=0; i<4; i++)
//    {
//        if (origin->subTriangles[i] != NULL)
//        {
//            dest->subTriangles[i] = new Triangle();
//            Sphere::copyTriangle(origin->subTriangles[i], dest->subTriangles[i], n, v);
//        }
//    }
//}

Sphere::Sphere(void) {}

Sphere::~Sphere(void) {}

int Sphere::init(World * w)
{
    Sphere::makeIsocaedre();

    float textFactor = 18;
    // init texture coordonates
    for (int i=0; i<12; i++)
    {
        Sphere::textureCoordonates1[2*Sphere::faces->vertices[i]] = 0.1f  * textFactor;
        Sphere::textureCoordonates1[2*Sphere::faces->vertices[i] + 1] = 0.1f  * textFactor;
        Sphere::colorCoordonates[Sphere::faces->vertices[i]] = 0;
    }
    Sphere::textureCoordonates1[2*Sphere::faces->vertices[1]] = 1  * textFactor;
    Sphere::textureCoordonates1[2*Sphere::faces->vertices[2]] = 0.5f  * textFactor;
    Sphere::textureCoordonates1[2*Sphere::faces->vertices[2] + 1] = 0.1f+sqrtf(3)/2  * textFactor;

    textFactor = 1;
    // init texture coordonates
    for (int i=0; i<12; i++)
    {
        Sphere::textureCoordonates2[2*Sphere::faces->vertices[i]] = 0.1f  * textFactor;
        Sphere::textureCoordonates2[2*Sphere::faces->vertices[i] + 1] = 0.1f  * textFactor;
        Sphere::colorCoordonates[Sphere::faces->vertices[i]] = 0;
    }
    Sphere::textureCoordonates2[2*Sphere::faces->vertices[1]] = 1  * textFactor;
    Sphere::textureCoordonates2[2*Sphere::faces->vertices[2]] = 0.5f  * textFactor;
    Sphere::textureCoordonates2[2*Sphere::faces->vertices[2] + 1] = 0.1f+sqrtf(3)/2  * textFactor;

    // extrude triangles
    int v=12;
    Sphere::extrudeTriangle(Sphere::faces, v, NUMBER_OF_EXTRUSIONS);
    for (int i=1; i<20; i++)
        Sphere::extrudeTriangle(Sphere::faces+i, v, 1);
    int oldv = v;
    //cout << "after extrusion, " << v << " points." << endl;
    Planet::digTunnels(0.34f, 0.098f, w, oldv);

    for (int i=0; i<4; i++)
        Sphere::faces[20].subTriangles[i] = NULL;
    for (int i=0; i<3; i++)
        Sphere::faces[20].vertices[i] = Sphere::faces[0].vertices[i];
    Sphere::extrudeTriangle(Sphere::faces+20, v, NUMBER_OF_EXTRUSIONS);
    for (int i=3*oldv; i<3*v; i++)
        Sphere::normalsCoordonates[i] = Sphere::verticesCoordonates[i];

    //Sphere::copyTriangle(Sphere::faces, Sphere::faces+20, v, v);
    //cout << "after copyTriangle, " << v << " points." << endl;
    return v;
}

void Sphere::drawFace1(Triangle * p, int n, float *c)
{
    if (p)
    {
        if (p->subTriangles == NULL || n == 0)
        {
            for (int i=0; i<3; i++)
            {
                glColor3fv(c);
                glTexCoord2fv(Sphere::textureCoordonates1 + 2 * p->vertices[i]);
                glNormal3fv(Sphere::normalsCoordonates + 3 * p->vertices[i]);
                glVertex3fv(Sphere::verticesCoordonates + 3 * p->vertices[i]);
            }
        }
        else for (int j = 0; j < 4; j++)
        {
            drawFace1(p->subTriangles[j], n-1, c);
        }
    }
}

void Sphere::drawFace2(Triangle * p, int n, float *c)
{
    if (p)
    {
        if (p->subTriangles == NULL || n == 0)
        {
            for (int i=0; i<3; i++)
            {
                glColor3fv(c);
                glTexCoord2fv(Sphere::textureCoordonates2 + 2 * p->vertices[i]);
                glNormal3fv(Sphere::normalsCoordonates + 3 * p->vertices[i]);
                glVertex3fv(Sphere::verticesCoordonates + 3 * p->vertices[i]);
            }
        }
        else for (int j = 0; j < 4; j++)
        {
            drawFace2(p->subTriangles[j], n-1, c);
        }
    }
}

void Sphere::drawFaceW(Triangle * p, int n)
{
    if (p)
    {
        if (p->subTriangles == NULL || n == 0)
        {
            glBegin(GL_LINE_LOOP);
            for (int i=0; i<3; i++)
            {
                glNormal3fv(Sphere::normalsCoordonates + 3 * p->vertices[i]);
                glVertex3fv(Sphere::verticesCoordonates + 3 * p->vertices[i]);
            }
            glEnd();
        }
        else for (int j = 0; j < 4; j++)
        {
            drawFaceW(p->subTriangles[j], n-1);
        }
    }
}

void Sphere::drawFace1(Triangle * p, int n, float *cExt, float *cInt)
{
    if (p)
    {
        if (p->subTriangles == NULL || n == 0)
        {
            for (int i=0; i<3; i++)
            {
                float c = Sphere::colorCoordonates[p->vertices[i]];
                glColor3f((1-c)*cExt[0]+c*cInt[0], (1-c)*cExt[1]+c*cInt[1], (1-c)*cExt[2]+c*cInt[2]);
                glTexCoord2fv(Sphere::textureCoordonates1 + 2 * p->vertices[i]);
                glNormal3fv(Sphere::normalsCoordonates + 3 * p->vertices[i]);
                glVertex3fv(Sphere::verticesCoordonates + 3 * p->vertices[i]);
            }
        }
        else for (int j = 0; j < 4; j++)
        {
            drawFace1(p->subTriangles[j], n-1, cExt, cInt);
        }
    }
}

void Sphere::drawFace2(Triangle * p, int n, float *cExt, float *cInt)
{
    if (p)
    {
        if (p->subTriangles == NULL || n == 0)
        {
            for (int i=0; i<3; i++)
            {
                float c = Sphere::colorCoordonates[p->vertices[i]];
                glColor3f((1-c)*cExt[0]+c*cInt[0], (1-c)*cExt[1]+c*cInt[1], (1-c)*cExt[2]+c*cInt[2]);
                glTexCoord2fv(Sphere::textureCoordonates2 + 2 * p->vertices[i]);
                glNormal3fv(Sphere::normalsCoordonates + 3 * p->vertices[i]);
                glVertex3fv(Sphere::verticesCoordonates + 3 * p->vertices[i]);
            }
        }
        else for (int j = 0; j < 4; j++)
        {
            drawFace2(p->subTriangles[j], n-1, cExt, cInt);
        }
    }
}

void Sphere::drawFaceW(Triangle * p, int n, float *cExt, float *cInt)
{
    if (p)
    {
        if (p->subTriangles == NULL || n == 0)
        {
            glBegin(GL_LINE_LOOP);
            for (int i=0; i<3; i++)
            {
                float c = Sphere::colorCoordonates[p->vertices[i]];
                glColor3f((1-c)*cExt[0]+c*cInt[0], (1-c)*cExt[1]+c*cInt[1], (1-c)*cExt[2]+c*cInt[2]);
                glNormal3fv(Sphere::normalsCoordonates + 3 * p->vertices[i]);
                glVertex3fv(Sphere::verticesCoordonates + 3 * p->vertices[i]);
            }
            glEnd();
        }
        else for (int j = 0; j < 4; j++)
        {
            drawFaceW(p->subTriangles[j], n-1, cExt, cInt);
        }
    }
}

void Sphere::loadTexture(char * fileName, GLuint * tId)
{
    glEnable(GL_COLOR_MATERIAL);

    try
    {
        glEnable(GL_TEXTURE_2D);

        glGenTextures(1, tId);

    	SDL_Surface *texture = SDL_LoadBMP(fileName);
        if (texture)
        {
	        glBindTexture(GL_TEXTURE_2D, *tId);
            gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, 
			    texture->w, texture->h,
			    GL_BGR, GL_UNSIGNED_BYTE, 
			    texture->pixels);
	        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, 
			    GL_LINEAR_MIPMAP_LINEAR);
	        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, 
			    GL_LINEAR_MIPMAP_LINEAR);

	        SDL_FreeSurface(texture);
        }
    }
    catch(char * s)
    {
        cout << s << endl;
    }
}

void Sphere::makeIcodahedronRotation(int faceNumber)
{
    float t, * a;
    switch (faceNumber)
    {
    case(0):
        glFrontFace(GL_CCW);
        t = 0;
        a = Sphere::verticesCoordonates;
        break;
    case(1):
        glFrontFace(GL_CCW);
        t = 288;
        a = Sphere::verticesCoordonates;
        break;
    case(2):
        glFrontFace(GL_CCW);
        t = 72;
        a = Sphere::verticesCoordonates;
        break;
    case(3):
        glFrontFace(GL_CCW);
        t = 216;
        a = Sphere::verticesCoordonates;
        break;
    case(4):
        glFrontFace(GL_CCW);
        t = 144;
        a = Sphere::verticesCoordonates;
        break;
    case(5):
        glFrontFace(GL_CCW);
        t = 72;
        a = Sphere::verticesCoordonates + 6;
        break;
    case(6):
        glFrontFace(GL_CCW);
        t = 72;
        a = Sphere::verticesCoordonates + 12;
        break;
    case(7):
        glFrontFace(GL_CCW);
        t = 216;
        a = Sphere::verticesCoordonates + 3;
        break;
    case(8):
        glFrontFace(GL_CCW);
        t = 72;
        a = Sphere::verticesCoordonates + 15;
        break;
    case(9):
        glFrontFace(GL_CCW);
        t = 72;
        a = Sphere::verticesCoordonates + 21;
        break;
    case(10):
        glFrontFace(GL_CW);
        t = 144;
        a = Sphere::verticesCoordonates + 3;
        glScalef(-1, 1, 1);
        break;
    case(11):
        glFrontFace(GL_CW);
        t = 216;
        a = Sphere::verticesCoordonates + 9;
        glScalef(1, -1, 1);
        break;
    case(12):
        glFrontFace(GL_CW);
        t = 72;
        a = Sphere::verticesCoordonates + 3;
        glScalef(1, -1, 1);
        break;
    case(13):
        glFrontFace(GL_CW);
        t = 144;
        a = Sphere::verticesCoordonates + 3;
        glScalef(1, -1, 1);
        break;
    case(14):
        glFrontFace(GL_CW);
        t = 144;
        a = Sphere::verticesCoordonates;
        glScalef(1, -1, 1);
        break;
    case(15):
        glFrontFace(GL_CW);
        t = 288;
        a = Sphere::verticesCoordonates + 3;
        glScalef(-1, 1, 1);
        break;
    case(16):
        glFrontFace(GL_CCW);
        t = 216;
        a = Sphere::verticesCoordonates + 12;
        break;
    case(17):
        glFrontFace(GL_CCW);
        t = 144;
        a = Sphere::verticesCoordonates + 9;
        break;
    case(18):
        glFrontFace(GL_CCW);
        t = 144;
        a = Sphere::verticesCoordonates + 12;
        break;
    case(19):
        glFrontFace(GL_CW);
        t = 0;
        a = Sphere::verticesCoordonates + 3;
        glScalef(-1, -1, -1);
        break;
    default:
        break;
    }
    glRotatef(t, a[0], a[1], a[2]);
}