#ifndef SNAKE_H_
#define SNAKE_H_

class World;

#define SNAKE_LENGTH 50
#define SNAKE_TAIL_LENGTH 10
#define SNAKE_NECK_LENGTH 0.008f
#define SNAKE_HEAD_LENGTH 0.01f
#define SNAKE_HEAD_WIDTH 0.007f
#define SNAKE_HEAD_HEIGHT 0.002f
#define SNAKE_RADIUS 0.012f
#define SNAKE_TESSELIZATION 10
#define SNAKE_RING_LENGTH 0.015f
#define SNAKE_SPEED 5
#define SNAKE_AMPLITUDE 0.4f
#define SNAKE_PULSE 18
#define SNAKE_EYES_HEIGHT 0.015f
#define SNAKE_EYES_RADIUS 0.005f
#define SNAKE_EYES_PARALAX 0.017f

#define NO_IMPACT -1

class Snake
{
public:
    Snake(World * w, float x, float y, float z, float tx, float ty, float tz, int pl);
    ~Snake(void);

    struct Ring
    {
        float p[3], n[3], v[3], t[3];
        float verticesCoordonates[3*SNAKE_TESSELIZATION];
        float normalCoordonates[3*SNAKE_TESSELIZATION];
        int planet, face;
        bool insideHole;
        float radius;
    };

    int planet1, planet2;
    float tail[3], tr[3];

    int alpha;
    static float * cosalpha;
    static float * trigo;
    static float * textureCoordonates;
    static float dl;
    struct Ring rings[SNAKE_LENGTH];
    int firstRing;

    void update(World * w);
    void translateTail(float * tr);
    bool isOnPlanet(int pl);
    bool isOnPlanet(int pl, int fc);
    void draw(World * w, bool isDistant);
    void drawHead(Ring * ring, float lCoord2);
    void drawHeadW(Ring * ring, float lCoord2);
    void drawEyes(Ring * ring, World * w);
    void drawEyesW(Ring * ring, World * w);

    int detectImpact(Star * star);
    bool detectImpact(Snake ** snakes);
    bool detectImpact(float * p, float r, int pl);
    bool detectHeadImpact(float * p, float r);
    int closestRing(float * p, int r0);

private:
    static void precomputeTrigoValues(int N);
    static void precomputeTextureCoords(int N);
    void positionNextRing(Ring * ring, int face, World * w);
    static void computeVertices(Ring * ring);
};

#endif