#include "World.h"

Sky::Sky() : Sphere()
{
    this->textureCoordonates = new float[2*3];
    this->textureCoordonates[0]  = 0;
    this->textureCoordonates[1]  = 0;
    this->textureCoordonates[2]  = 3;
    this->textureCoordonates[3]  = 0;
    this->textureCoordonates[4]  = 1.5f;
    this->textureCoordonates[5]  = 2.59807621f;
}

Sky::~Sky(void)
{
}

void Sky::draw(World * w)
{
    //glDisable(GL_LIGHT0);
    glEnable(GL_LIGHT1);
    //glEnable(GL_LIGHT2);
    glPushMatrix();
    float skyDistance = 80.f;
    glScalef(skyDistance,skyDistance,skyDistance);
    glColor4f(1, 1, 1, 1);

    glBindTexture(GL_TEXTURE_2D, w->skyTextureId);
    glBegin(GL_TRIANGLES);

    Triangle * p = this->faces;
    for (int i = 0; i < 20; i++)
    {
        for (int j=0; j<3; j++)
        {
            glTexCoord2fv(this->textureCoordonates + 2*j);
            float * x1 = Sphere::verticesCoordonates + 3 * p->vertices[j];
            glNormal3fv(x1);
            glVertex3fv(x1);
        }
        p++;
    }
    glEnd();
    glFlush();

    glPopMatrix();
    //glEnable(GL_LIGHT0);
    glDisable(GL_LIGHT1);
    //glDisable(GL_LIGHT2);
}