#include "Player.h"
#include "World.h"
#include "Tunnel.h"

Player::Player(float r, float x, float y, float z, float xt, float yt, float zt, int pl, World * w)
: Star(r)
{
    w->currentPlanet = pl;

    float n = sqrtf(x*x+y*y+z*z);
    w->p[0] = x/n;
    w->p[1] = y/n;
    w->p[2] = z/n;
    w->t[0] = xt;
    w->t[1] = yt;
    w->t[2] = zt;

    for (int i=0; i<3; i++)
    {
        this->c1[i] = 0.7f;
        this->c2[i] = 0;
    }

    this->angle = 30;
    this->radiusInt = 0.7f;

    this->health = 100;
    
    float * translate = new float[3];
    for (int i=0; i<3; i++) translate[i] = w->planets[w->currentPlanet]->position[i];
    for (int i=0; i<NUMBER_OF_PLANETS; i++)
        for (int j=0; j<3; j++)
            w->planets[i]->position[j] -= translate[j];
    delete[] translate;

    for (int i=0; i<NUMBER_OF_MISSILES; i++)
        this->missile[i] = new Missile(0.02f, w->p[0], w->p[1], w->p[2], w->t[0], w->t[1], w->t[2], w->currentPlanet, w);
}

Player::~Player(void)
{
}

void Player::update(World * w)
{
    this->planet = w->currentPlanet;

    for (int i=0; i<3; i++)
    {
        //this->q[i] = w->p[i];
        this->position[i] = w->p[i] + this->radius * (1.5f - this->radiusInt) * 0.9f*w->top[i];
    }

    this->angle += (360 * w->dp) / (6.28318531f * this->radius * (1.5f - this->radiusInt));

    //if (w->mv_shift)
    //{
    //    if (w->mv_forward) 
    //        this->angle += 80;
    //    if (w->mv_backward) this->angle -= 80;
    //}
    //else
    //{
    //    if (w->mv_forward) this->angle += 20;
    //    if (w->mv_backward) this->angle -= 20;
    //}

    float dp = w->dp; 
    if (dp<0) dp = -dp;
    this->radiusInt = 1-55*dp;
    if (this->radiusInt < 0.1f) this->radiusInt = 0.1f;

    for (int i=0; i<NUMBER_OF_MISSILES; i++)
        if (this->missile[i]->isAlive)
            this->missile[i]->update(w);
}

void Player::checkMissilesForMutualImpact(World * w)
{
    for (int i=0; i<NUMBER_OF_MISSILES; i++)
    {
        bool boom = false;
        Missile * m1 = this->missile[i];
        if (m1->isAlive
            && m1->explosionFactor == 0)
        {
            for (int j=i+1; j<NUMBER_OF_MISSILES; j++)
            {
            
                Missile * m2 = this->missile[j];
                if (m2->isAlive
                    && m2->explosionFactor == 0)
                {
                    float d = 0;
                    for (int i=0; i<3; i++)
                    {
                        float dd = m1->q[i] - m2->q[i];
                        d += dd*dd;
                    }
                    float R = 2 * m1->radius;
                    if (d < R*R) 
                    {
                        boom = true;
                        m2->explode(w);
                    }
                }
            }
        }
        if (boom) m1->explode(w);
    }
}

int Player::selectMissile()
{
    int maxAge = -1;
    int oldest = 0;

    for (int i=0; i<NUMBER_OF_MISSILES; i++)
        if (! this->missile[i]->isAlive)
        {
            return i;
        }
        else
        {
            if (this->missile[i]->age > maxAge)
            {
                maxAge = this->missile[i]->age;
                oldest = i;
            }
        }

    return oldest;
}

void Player::shoot(World * w)
{
    // look for the first dead missile or the oldest alive missile
    int i=this->selectMissile();

    // initialize and shoot it
    this->missile[i]->reset(w);

    w->playSound(SOUND_MISSILE_LAUNCH, MY_SDL_MIX_MAXVOLUME);
}

void Player::draw(World * w)
{   
    glPushMatrix();
    glTranslatef(this->position[0], this->position[1], this->position[2]);

    glRotatef(this->angle, w->v[0], w->v[1], w->v[2]);
    float mainRadius = this->radius * (1.5f - this->radiusInt);
    glScalef(mainRadius,mainRadius,mainRadius);

    glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
    if (w->wire)
        this->drawHelperW(w, this->c1, this->c2);
    else
        this->drawHelper(w, this->c1, this->c2);
    glPopMatrix();
}