#ifndef PLANET_H_
#define PLANET_H_

#include "Sphere.h"

class Tunnel;

class Planet: public Sphere
{
public:
    int id;

    Planet(int i, float x, float y, float z, float r, float g, float b);
    ~Planet(void);

    void draw(World * w);
    void drawCurrentPlanet(World * w);
    static int getCurrentFace(float * p, int & formerFace);
    static void digTunnels(float radiusExt, float radiusInt, World * w, int n);

    static void connectTunnels(World * w);

    static Tunnel * tunnels;
    static int * oppositeTunnels;
    float position[3];
    float color[3];

private:

    bool isVisible(float * pos, Triangle * face, World * w);
    bool isVisible2(int face, World * w);
    bool isVisible2bis(Triangle * face, World * w);
    bool isVisible3(float * pos, Triangle * face, World * w);
    bool isVisible4(Triangle * face, World * w);
    int tesselisationLevel(float x, float y, float z, int n, World * w);
    static bool isInFace(float * p, Triangle * face);
    static int oppositeTunnel(int t);
    void drawDistantPlanet(float * pos, World * w);
};

#endif