#include "Planet.h"
#include "World.h"
#include "Tunnel.h"

// static
Tunnel * Planet::tunnels = new Tunnel[20];
int * Planet::oppositeTunnels = new int[20];

Planet::Planet(int i, float x, float y, float z, float r, float g, float b) 
: Sphere()
{
    this->id = i;
    this->position[0] = x;
    this->position[1] = y;
    this->position[2] = z;
    this->color[0] = r;
    this->color[1] = g;
    this->color[2] = b;
}

Planet::~Planet(void)
{
}

void Planet::digTunnels(float radiusExt, float radiusInt, World * w, int n)
{
    Tunnel::init(Planet::tunnels, radiusExt, radiusInt, w, n);
}

//void Planet::setTunnelDirections(Planet ** planets, int nPlanets)
//{
//    int * k = new int[nPlanets]; // counter
//
//    for (int i=0; i<nPlanets; i++)
//    {
//        k[i] = 0;
//        for (int j=0; j<20; j++)
//            planets[i]->tunnelDirections[j] = NULL;
//    }
//
//    int l=0;
//    for (int i=0; i<nPlanets; i++)
//    {
//        for (int j=0; j<20; j++)
//        {
//            if (!planets[i]->tunnelDirections[j])
//            {
//                // choose the planet to link with planets[i]->tunnel[j]
//                l = (l+1) % nPlanets;
//                while (l==i || k[l] == 20) l = (l+1) % nPlanets;
//                //cout << "choosing l=" << l;
//
//                // choose the tunnel on planets[l] to link with planets[i]->tunnel[j]
//                int m = (7*l) % 20;
//                while (planets[l]->tunnelDirections[m]) m = (m+1) % 20;
//                //cout << " and m=" << m << "; ";
//
//                planets[i]->tunnelDirections[j] = planets[l];
//                planets[l]->tunnelDirections[m] = planets[i];
//                planets[i]->tunnelExits[j] = m;
//                planets[l]->tunnelExits[m] = j;
//                k[i]++;
//                k[l]++;
//                //cout << "k[" << i << "]=" << k[i] << " and "  << "k[" << l << "]=" << k[l] << endl;
//            }
//        }
//    }
//    delete[] k;
//}

bool Planet::isInFace(float * p, Triangle * face)
{
    for (int j=0; j<3; j++)
    {
        float scal = 0;
        float * vertice = Sphere::verticesCoordonates + 3 * face->vertices[j];
        for (int k=0; k<3; k++) scal += p[k] * vertice[k];
        if (scal < 0.4472) return false;
    }
    return true;
}

int Planet::getCurrentFace(float * p, int & formerFace)
{
    // normalize p in a copy q of it
    float q[3];
    float norm = sqrt((float) p[0]*p[0]+p[1]*p[1]+p[2]*p[2]);
    for (int i=0; i<3; i++) q[i] = p[i] / norm;

    for (int i=formerFace; i<20; i++)
        if (Planet::isInFace(q, Sphere::faces + i))
        {
            #ifdef TRACE_FACE_JUMPS
            if (formerFace != i)
                cout << "going from face " << formerFace << " to face " << i << endl;
            #endif
            return (formerFace = i);
        }
    for (int i=0; i<formerFace; i++)
        if (Planet::isInFace(q, Sphere::faces + i))
        {
            #ifdef TRACE_FACE_JUMPS
            if (formerFace != i)
                cout << "going from face " << formerFace << " to face " << i << endl;
            #endif
            return (formerFace = i);
        }

    //cout << "failed to find current face" << endl;
    return formerFace;
}

int Planet::oppositeTunnel(int t)
{
    for (int i=0; i<20; i++)
    {
        if ((i<10 && (i%2)==0) || (t<10 && (t%2)==0))
        {
            float d = 0;
            for (int j = 0; j<3; j++)
                {
                    float dd = Planet::tunnels[t].axis[j] + Planet::tunnels[i].axis[j];
                    d += dd * dd;
                }
            if (d < 0.001) return i;
        }
    }
    return -1;
}

void Planet::connectTunnels(World * w)
{
    for (int i=0; i<20; i++) 
        oppositeTunnels[i] = oppositeTunnel(i);

#ifdef TRACE_TUNNEL_CONNECTIONS
    cout << "Opposite tunnels:" << endl;
    for (int i=0; i<10; i++) cout << " " << i << " ";
    for (int i=10; i<20; i++) cout << i << " ";
    cout << endl;
    for (int i=0; i<20; i++)
    {
        if (oppositeTunnels[i] < 10) cout << " ";
        if (oppositeTunnels[i] == -1) cout << "- ";
        else cout << oppositeTunnels[i] << " ";
    }
    cout << endl << endl;
#endif

    int * tun = w->tunnelConnections;
    for (int i=0; i<120; i++) tun[i] = -1;

    int l = 0;
    // for each tunnel (entries only - 10 to 19 are the opposite tunnels)
    for (int i=0; i<10; i++)
    {
        // on each planet
        for (int j=0; j<6; j++)
        {
            int k = (i+j+l+1) % 6;
            if (k==j) {k=(k+1)%6; l++;}
            if (oppositeTunnels[i] != -1)
            {
                tun[20*j+i] = k;
                tun[20*k+Planet::oppositeTunnels[i]] = j;
            }
        }
    }

#ifdef TRACE_TUNNEL_CONNECTIONS
    cout << "Tunnel connections for " << NUMBER_OF_PLANETS << " planets with 20 tunnels on each:"
        << endl<< "P | ";
    for (int j=0; j<2; j++) for (int i=0; i<10; i++) cout << i << " ";
    cout << "| R G B" << endl << "--+-";
    for (int j=0; j<2; j++) for (int i=0; i<10; i++) cout << "--";
    cout << "+-------" << endl;
    for (int j=0; j<6; j++)
    {
        cout << j << " | ";
        for (int i=0; i<20; i++)
            if (tun[20*j + i] >= 0) cout << tun[20*j + i] << " ";
            else cout << "- ";
        cout << "| ";
        for (int i=0; i<3; i++) cout << (int)(w->planets[j]->color[i]*10) << " ";
        cout << endl;
    }
    cout << endl;
#endif
}

//void Planet::connectTunnels(World * w)
//{
//    for (int i=0; i<20; i++) 
//        cout << i << " " << oppositeTunnel(i) << endl;
//
//    int * tun = w->tunnelConnections;
//    for (int i=0; i<120; i++) tun[i] = -1;
//
//    // for each group of 5 tunnels
//    for (int l=0; l<4; l++)
//    {
//        // for each tunnel
//        for (int i=0; i<5; i++)
//        {
//            // on each planet
//            for (int j=0; j<6; j++)
//            {
//                // if this planet's tunnel number i hasn't been connected yet
//                if (tun[(i+5*l) + 20 * j] == -1) // tun[i][j] free
//                {
//                    // shift the place you start searching from
//                    int k = (j+i+1)%6;
//                    // search for a free spot: k!=j with tun[i][k] free
//                    while (tun[(i+5*l)+20*k] != -1 || k == j) k = (k+1) % 6;
//                    // connect the tunnel at both ends
//                    tun[(i+5*l)+20*k] = j;
//                    tun[(i+5*l)+20*j] = k;
//                }
//            }
//        }
//    }
//
//#ifdef TRACE_TUNNEL_CONNECTIONS
//    cout << "Tunnel connections for " << NUMBER_OF_PLANETS << " planets with 20 tunnels on each:"
//        << endl<< "P | ";
//    for (int j=0; j<2; j++) for (int i=0; i<10; i++) cout << i << " ";
//    cout << "| R G B" << endl << "--+-";
//    for (int j=0; j<2; j++) for (int i=0; i<10; i++) cout << "--";
//    cout << "+-------" << endl;
//    for (int j=0; j<6; j++)
//    {
//        cout << j << " | ";
//        for (int i=0; i<20; i++)
//            cout << tun[20*j + i] << " ";
//        cout << "| ";
//        for (int i=0; i<3; i++) cout << (int)(w->planets[j]->color[i]*10) << " ";
//        cout << endl;
//    }
//    cout << endl;
//#endif
//}

int Planet::tesselisationLevel(float x, float y, float z, int n, World * w)
{
    if (w->pauseGame)
    {
        return n;
    }
    else
    {
        float distance = 0;
        float d = w->eye[0] - x;
        distance += d*d;
        d = w->eye[1] - y;
        distance += d*d;
        d = w->eye[2] - z;
        distance += d*d;
        //float d = this->position[0] - x;
        //distance += d*d;
        //d = this->position[1] - y;
        //distance += d*d;
        //d = this->position[2] - z;
        //distance += d*d;

        if (distance>65) return n - 3;
        if (distance>45) return n - 2;
        if (distance>3) return n - 1;
        return n;
    }
}

bool Planet::isVisible(float * pos, Triangle * face, World * w)
    // pos has to be relative to w->eye
{
    // prune planets that are behind the camera
    float vSl = 0;
    for (int i=0; i<3; i++)
        vSl += (pos[i]-w->eye[i])*(w->front[i]-w->eye[i]); 
    // no need to normalize the dot prod since we're only concerned about its sign
    if (vSl < 0) return false;

    // prune faces on other planets that face backward: if any of the three vertices
    // is in view, draw the whole face (is a good enough approximation for distant planets)
    for (int j=0; j<3; j++)
    {
        float vSl = 0;
        float * vertice = Sphere::verticesCoordonates + 3 * face->vertices[j];
        for (int i=0; i<3; i++)
            vSl += vertice[i] * (w->front[i]-w->eye[i]);
        if (vSl < 0)
            //|| vSl * vSl < 0.11f*(w->closeBehind*w->closeBehind+w->closeTop*w->closeTop)) 
            return true;
    }
    return false;
}

bool Planet::isVisible2(int face, World * w)
{
    // prune faces on current planet that face "backward"
    float * ax1 = w->eye;//Planet::tunnels[w->currentFace].axis;
    float * ax2 = Planet::tunnels[face].axis;
    float s = 0;
    for (int i=0; i<3; i++) s += ax1[i]*ax2[i];
    return (s > 0.38f); //0.32f);
}

bool Planet::isVisible2bis(Sphere::Triangle * face, World * w)
{
    float * ax1 = w->eye;//Planet::tunnels[w->currentFace].axis;
    float ax2[3] = {0,0,0}; 
    for (int i=0; i<3; i++)
        ax2[i] += (Sphere::verticesCoordonates[3 * face->vertices[0] + i]
                 + Sphere::verticesCoordonates[3 * face->vertices[1] + i]
                 + Sphere::verticesCoordonates[3 * face->vertices[2] + i]);

    float s = 0;
    for (int i=0; i<3; i++) s += ax1[i]*ax2[i];
    return (s > 0); //0.32f);
}

bool Planet::isVisible3(float * pos, Triangle * face, World * w)
    // pos has to be relative to w->eye
{
    if (!face) return false;

    // prune faces on other planets that face backward: if any of the three vertices
    // is in view, draw the whole face (is a good enough approximation for distant planets)
    for (int j=0; j<3; j++)
    {
        float vSl = 0;
        float * vertice = Sphere::verticesCoordonates + 3 * face->vertices[j];
        for (int i=0; i<3; i++)
            vSl += vertice[i] * (w->front[i]-w->eye[i]);
        if (vSl < 0.15f*sqrtf((w->closeBehind*w->closeBehind+w->closeTop*w->closeTop))) return true;
    }
    return false;
}

bool Planet::isVisible4(Triangle * face, World * w)
{
    if (!face) return false;

    // prune faces on current planet that form to wide an angle with the eye
    float * ax1 = w->eye;//Planet::tunnels[w->currentFace].axis;
    float * ax2;
    for (int i=0; i<3; i++)
    {
        ax2 = Sphere::verticesCoordonates + 3 * face->vertices[i];
        float s = 0;
        for (int i=0; i<3; i++) s += ax1[i] * ax2[i];
        if (s > 0.38f) return true;
    }
    return false;
}

void Planet::drawCurrentPlanet(World * w)
{
    int otherPlanet;
    float * otherColor;

    if (w->wire)
    {
        glLineWidth(4);
        glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
    }
    else
    {
        glEnable(GL_CULL_FACE);
        glBindTexture(GL_TEXTURE_2D, w->planetTextureId1);
    }

    if (Planet::oppositeTunnels[w->currentFace] != -1)
    {
        otherPlanet= w->tunnelConnections[20 * w->currentPlanet + w->currentFace];
        otherColor = w->planets[otherPlanet]->color;
    }

    // first draw the outside, which if (lookingDown) is only the current face
    if (w->lookingDown)
    {
        glPushMatrix();
        Sphere::makeIcodahedronRotation(w->currentFace);

        if (w->wire)
        {
            drawFaceW(Sphere::faces, NUMBER_OF_EXTRUSIONS, this->color, otherColor);
        }
        else
        {
            glBegin(GL_TRIANGLES);
            drawFace1(Sphere::faces, NUMBER_OF_EXTRUSIONS, this->color, otherColor);
            glEnd();
        }
        glPopMatrix();
    }
    else
    {
        for (int i=0; i<20; i++)
        {
            if (isVisible2(i, w))
            {
                glPushMatrix();
                Sphere::makeIcodahedronRotation(i);

                for (int j=0; j<4; j++)
                    if (isVisible2bis(Sphere::faces[i].subTriangles[j], w))
                    {
                        if (w->wire)
                        {
                            if (Planet::oppositeTunnels[i] != -1)
                                drawFaceW(Sphere::faces->subTriangles[j], NUMBER_OF_EXTRUSIONS - 1, this->color, 
                                    w->planets[w->tunnelConnections[20 * this->id + i]]->color);
                            else
                            {
                                glColor3fv(this->color);
                                drawFaceW(Sphere::faces[20].subTriangles[j], NUMBER_OF_EXTRUSIONS - 1);
                            }
                        }
                        else
                        {
                            glBegin(GL_TRIANGLES);
                            if (Planet::oppositeTunnels[i] != -1)
                                drawFace1(Sphere::faces->subTriangles[j], NUMBER_OF_EXTRUSIONS - 1, this->color, 
                                    w->planets[w->tunnelConnections[20 * this->id + i]]->color);
                            else
                                drawFace1(Sphere::faces[20].subTriangles[j], NUMBER_OF_EXTRUSIONS - 1, this->color);
                            glEnd();
                        }
                    }

                glPopMatrix();
            }
        }
    }

    // finally draw the planet again if we can see it through the tunnel
    // this will happen if the planet below the hole is upon the hole 
    // (since you'll exit below that planet, and thus have the planet you
    // come from in front of you)
    if (w->lookingDown)
    {
        // center of the planet on the other side of the tunnel we're looking through
        float * trs = new float[3];
        Tunnel * tun = Planet::tunnels + w->currentFace;
        for (int i=0; i<3; i++)
            trs[i] = 2*tun->yC*tun->axis[i] - w->planets[otherPlanet]->position[i];
        this->drawDistantPlanet(trs, w);
        delete[] trs;
    }

    if (Planet::oppositeTunnels[w->currentFace] != -1)
    {
        if (w->wire)
        {
            glLineWidth(4);
            glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
        }
        else
            glBindTexture(GL_TEXTURE_2D, w->planetTextureId1);

        // then draw the inside face (behind the hole) if onTunnel
        if (w->onTunnel)
        {   
            glPushMatrix();
            float * ax = new float[3];
            for (int j=0; j<3; j++)
                ax[j] = Sphere::verticesCoordonates[3*Sphere::faces[w->currentFace].vertices[1]+j]
                    - Sphere::verticesCoordonates[3*Sphere::faces[w->currentFace].vertices[0]+j];
            glRotatef(180, ax[0], ax[1], ax[2]);
            delete[] ax;
            ax = Planet::tunnels[w->currentFace].axis;
            glRotatef(180, ax[0], ax[1], ax[2]);
            float trans = -1.5412f;  //-1.47955f;
            glTranslatef(trans*ax[0], trans*ax[1], trans*ax[2]);
            Sphere::makeIcodahedronRotation(w->currentFace);
            if (w->wire)
            {
                drawFaceW(Sphere::faces->subTriangles[3], NUMBER_OF_EXTRUSIONS-1, otherColor, this->color);
            }
            else
            {
                glBegin(GL_TRIANGLES);
                drawFace1(Sphere::faces->subTriangles[3], NUMBER_OF_EXTRUSIONS-1, otherColor, this->color);
                glEnd();
            }
            glPopMatrix();

            // draw as well the targets which are on this inside face, behind the hole, on the other planet
            for (int i=0; i<NUMBER_OF_TARGETS; i++)
            {
                if (w->targets[i]->isAlive
                    && w->targets[i]->planet == otherPlanet 
                    && w->targets[i]->face == Planet::oppositeTunnels[w->currentFace]
                    /*&& w->targets[i]->colorCoord > 0*/)
                {
                    glPushMatrix();
                    float * tr = w->targets[i]->tr;
                    glTranslatef(tr[0], tr[1], tr[2]);
                    //trans = -2 * Planet::tunnels[w->currentFace].yC;
                    //glTranslatef(trans * ax[0], trans * ax[1], trans * ax[2]);
                    w->targets[i]->draw(w); //drawOnTheOtherSideOfTheHole(w);
                    glPopMatrix();
                }
            }

            // draw as well the mines which are on this inside face, behind the hole, on the other planet
            for (int i=0; i<NUMBER_OF_MINES; i++)
                if (w->mines[i]->isAlive
                    && w->mines[i]->planet == otherPlanet 
                    && w->mines[i]->face == Planet::oppositeTunnels[w->currentFace])
                {
                    glPushMatrix();
                    float * tr = w->mines[i]->tr;
                    glTranslatef(tr[0], tr[1], tr[2]);
                    w->mines[i]->draw(w);
                    glPopMatrix();
                }

            //// draw the snakes that are on the other side of the hole
            //for (int i=0; i<NUMBER_OF_SNAKES; i++)
            //    if (w->snakes[i]->planet1 == otherPlanet && w->snakes[i]->planet2 == otherPlanet)
            //    if (w->snakes[i]->rings[(w->snakes[i]->firstRing/SNAKE_SPEED + 1) % SNAKE_LENGTH].face 
            //        == w->currentFace)
            //    {
            //        glPushMatrix();
            //        float * tr = w->snakes[i]->tr;
            //        glTranslatef(tr[0], tr[1], tr[2]);
            //        w->snakes[i]->draw(w, false);
            //        glPopMatrix();
            //    }
    
            // draw as well the missiles which are on this inside face, behind the hole, on the other planet
            for (int i=0; i<NUMBER_OF_MISSILES; i++)
                if (w->player->missile[i]->isAlive && w->player->missile[i]->planet == otherPlanet
                    && w->player->missile[i]->face == Planet::oppositeTunnels[w->currentFace])
                {
                    glPushMatrix();
                    float * tr = w->player->missile[i]->tr;
                    glTranslatef(tr[0], tr[1], tr[2]);
                    w->player->missile[i]->draw(w);
                    glPopMatrix();
                }
        }
    }
    
    for (int i=0; i<NUMBER_OF_TARGETS; i++)
        if (w->targets[i]->isAlive && w->targets[i]->planet == this->id)
        {
            float sc = 0;
            for (int j=0; j<3; j++) 
                sc += w->eye[j] * w->targets[i]->position[j];
            if (sc > 0)
                w->targets[i]->draw(w);
        }

    for (int i=0; i<NUMBER_OF_MINES; i++)
        if (w->mines[i]->isAlive && w->mines[i]->planet == this->id)
        {
            float sc = 0;
            for (int j=0; j<3; j++) 
                sc += w->eye[j] * w->mines[i]->q[j];
            if (sc > 0)
                w->mines[i]->draw(w);
        }

    for (int i=0; i<NUMBER_OF_SNAKES; i++)
        if (w->snakes[i]->planet1 == this->id)
        {
            float * sp = w->snakes[i]->rings->p;
            float ps = 0;
            for (int j=0; j<3; j++)
                ps += w->p[j] * sp[j];

            if (ps > 0.4f)
                w->snakes[i]->draw(w, false);
        }
        else if (w->snakes[i]->planet2 == this->id 
            && (w->lookingDown || w->snakes[i]->isOnPlanet(this->id)))
            //, Planet::oppositeTunnels[w->currentFace]))
        {
            float * sp = w->snakes[i]->rings->p;
            float * tr = w->snakes[i]->tr;
            float ps = 0;
            for (int j=0; j<3; j++)
                ps += w->p[j] * (sp[j] + tr[j]);

            if (ps > 0.4f)
            {
                glPushMatrix();
                glTranslatef(tr[0], tr[1], tr[2]);
                w->snakes[i]->draw(w, false);
                glPopMatrix();
            }
        }

    for (int i=0; i<NUMBER_OF_MISSILES; i++)
        if (w->player->missile[i]->isAlive && w->player->missile[i]->planet == this->id)
        {
            float sc = 0;
            for (int j=0; j<3; j++) 
                sc += w->eye[j] * w->player->missile[i]->position[j];
            if (sc > 0)
                w->player->missile[i]->draw(w);
        }

    glDisable(GL_CULL_FACE);

    if (w->wire)
        glLineWidth(1);
}

void Planet::draw(World * w)
{
    glEnable(GL_CULL_FACE);
    int otherPlanet;

    // the current planet is a special case. Face culling is different: if the observer is
    // on the tunnel, draw only the current face and its symetric below the hole; if not,
    // don't draw the symetric. Tesselization is different: for the current planet, use the 
    // highest level detail available. Plus, the current planet may be drawn twice, if the
    // observer is looking through a hole. And there is no translation for the first.
    if (this->id != w->currentPlanet)
    {
        // if drawing a distant planet through a hole, translate the planet to its
        // position relative to the planet that is on the other side of the hole.
        // that is, draw it seen from the other planet. Example:
        // "going from planet 2 to planet 3 through tunnel 0->19"
        if (w->lookingDown)
        {
            otherPlanet= w->tunnelConnections[20 * w->currentPlanet + w->currentFace];
            if (this->id != otherPlanet)
            {
                // center of the planet on the other side of the tunnel we're looking through
                float * trs = new float[3];
                Tunnel * tun = Planet::tunnels + w->currentFace;
                for (int i=0; i<3; i++)
                    trs[i] = this->position[i] + 2*tun->yC*tun->axis[i]
                           - w->planets[otherPlanet]->position[i];

                this->drawDistantPlanet(trs, w);
                delete[] trs;
            }
        }
        else
        {
            this->drawDistantPlanet(this->position, w);
        }    
        glDisable(GL_CULL_FACE);
    }
}

void Planet::drawDistantPlanet(float * pos, World * w)
{
    if (w->wire)
    {
        glLineWidth(2);
        glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
    }
    else
        glBindTexture(GL_TEXTURE_2D, w->planetTextureId2);

    glPushMatrix();
    glTranslatef(pos[0], pos[1], pos[2]);
    
    int tl = this->tesselisationLevel(w->eye[0]+pos[0], w->eye[1]+pos[1], w->eye[2]+pos[2], w->n, w);

    for (int i=0; i<20; i++)
    {
        if (isVisible(pos, Sphere::faces + i, w))
        {
            glPushMatrix();
            Sphere::makeIcodahedronRotation(i);

            for (int j=0; j<4; j++)
                //if (isVisible(pos, Sphere::faces[i].subTriangles[j], w))
                {
                    if (w->wire)
                    {
                        if (Planet::oppositeTunnels[i] != -1)
                            drawFaceW(Sphere::faces->subTriangles[j], tl-1, this->color, 
                                w->planets[w->tunnelConnections[20 * this->id + i]]->color);
                        else
                        {
                            glColor3fv(this->color);
                            drawFaceW(Sphere::faces[20].subTriangles[j], tl-1);
                        }
                    }
                    else
                    {
                        glBegin(GL_TRIANGLES);
                        if (Planet::oppositeTunnels[i] != -1)
                            drawFace2(Sphere::faces->subTriangles[j], tl-1, this->color, 
                                w->planets[w->tunnelConnections[20 * this->id + i]]->color);
                        else
                            drawFace2(Sphere::faces[20].subTriangles[j], tl-1, this->color);
                        glEnd();
                    }
                }

            glPopMatrix();
        }
    }

    glPolygonOffset(1.0f, -1.0f);
    glEnable(GL_POLYGON_OFFSET_FILL);
    for (int i=0; i<NUMBER_OF_TARGETS; i++)
        if (w->targets[i]->isAlive && w->targets[i]->planet == this->id)
        {
            float sc = 0;
            for (int j=0; j<3; j++) 
                sc += (pos[j] - w->eye[i]) * w->front[i];
                //sc += (w->targets[i]->position[j] - w->eye[i]) * (w->front[i] - w->eye[i]);
            if (sc < 0)
                w->targets[i]->draw(w);
        }

    for (int i=0; i<NUMBER_OF_SNAKES; i++)
        if (w->snakes[i]->planet1 == this->id)
        {
            float sc = 0;
            for (int j=0; j<3; j++) 
                sc += (pos[j] - w->eye[i]) * w->front[i];
            if (sc < 0)
            {
                w->snakes[i]->draw(w, true);
            }
        }
        else if (w->snakes[i]->planet2 == this->id && w->snakes[i]->isOnPlanet(this->id))
        {
            float sc = 0;
            for (int j=0; j<3; j++) 
                sc += (pos[j] - w->eye[i]) * w->front[i];
            if (sc < 0)
            {
                glPushMatrix();
                float * tr = w->snakes[i]->tr;
                glTranslatef(tr[0], tr[1], tr[2]);
                w->snakes[i]->draw(w, true);
                glPopMatrix();
            }
        }

    for (int i=0; i<NUMBER_OF_MISSILES; i++)
        if (w->player->missile[i]->isAlive && w->player->missile[i]->planet == this->id)
        {
            float sc = 0;
            for (int j=0; j<3; j++) 
                sc += (pos[j] - w->eye[i]) * w->front[i];
            if (sc > 0)
                w->player->missile[i]->draw(w);
        }
    glDisable(GL_POLYGON_OFFSET_FILL);

    glPopMatrix();

    if (w->wire)
        glLineWidth(1);
}