#include "World.h"
#include "Tunnel.h"

Mine::Mine(void)
    : Star(0.8f * INITIAL_EXT_RADIUS_TARGETS)
{
    this->isAlive = false;
    
    this->c2[0] = 1;
    this->c2[1] = 0.4f;
    this->c2[2] = 0;
    this->c1[0] = 0.2f;
    this->c1[1] = 0.8f;
    this->c1[2] = 0.2f;

    this->radiusInt = 0.2f;
}

Mine::~Mine(void)
{
}

int Mine::selectNextMine(World * w)
{
    int maxAge = -1;
    int oldest = 0;

    for (int i=0; i<NUMBER_OF_MINES; i++)
        if (! w->mines[i]->isAlive)
        {
            return i;
        }
        else
        {
            if (w->mines[i]->age > maxAge)
            {
                maxAge = w->mines[i]->age;
                oldest = i;
            }
        }

    return oldest;
}

void Mine::reset(World * w, float * p, float * n, int pl, int fc)
{
    this->isAlive = true;
    this->explosionFactor = 0;
    this->planet = pl;
    this->face = fc;

    Tunnel * tun = Planet::tunnels + fc;

    for (int j=0; j<3; j++)
    {
        this->q[j] = p[j] - 0.007f * n[j];
        this->n[j] = n[j];
        this->tr[j] = -2* tun->yC * tun->axis[j];
    }
    this->age = 0;
}

void Mine::update(World * w)
{
    if (this->explosionFactor == 1)
    {
        this->isAlive = false;
    }
    else
    {
        this->age++;
        if (this->explosionFactor != 0)
        {
            this->explosionFactor--;
        }
    }
}

bool Mine::isAtImpact(World * w)
{
    if (!this->isAlive) return false;
    if (this->planet != w->currentPlanet) return false;
    if (this->explosionFactor != 0) return false;

    float d = 0;
    for (int i=0; i<3; i++)
    {
        float dd = this->q[i] - w->p[i];
        d += dd*dd;
    }
    float R = this->radius + w->player->radius;
    if (d > R*R) return false;

    return true;
}

void Mine::explode(World * w)
{
    if (!this->isAlive) return;

    if (this->explosionFactor == 0)
    {
        w->playSound(SOUND_EXPLOSION_MINE, MY_SDL_MIX_MAXVOLUME);
        this->explosionFactor = 15;
    }
}

void Mine::draw(World * w)
{   
    glPushMatrix();

    glTranslatef(this->q[0], this->q[1], this->q[2]);

    //glRotatef(this->angle * (-2) /*(((SDL_GetTicks()/100) % 20) - 10)*/, this->v[0], this->v[1], this->v[2]);

    float mainRadius = this->radius * (1.5f - this->radiusInt);
    glScalef(mainRadius,mainRadius,mainRadius);

    if (w->wire)
    {
        if (this->explosionFactor == 0)
        {
            glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
            this->drawHelperW(w, this->c1, this->c2);
        }
        else
        {
            glScalef(0.5f, 0.5f, 0.5f);
            this->drawExplosionW(w, 1, 1, 1, 5 - ((float)this->explosionFactor)/3);
        }
    }
    else
    {
        if (this->explosionFactor == 0)
        {
            glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
            this->drawHelper(w, this->c1, this->c2);
        }
        else
        {
            glScalef(0.5f, 0.5f, 0.5f);
            this->drawExplosion(w, 1, 1, 1, 5 - ((float)this->explosionFactor)/3, 
                ((float)this->explosionFactor)/12, w->fireTextureId);
        }
    }

    glPopMatrix();
}

void Mine::drawHelper(World * w, float * c1, float * c2) // involves no geometric transformation
{
    glFrontFace(GL_CCW);
    glDisable(GL_CULL_FACE);

    glBegin(GL_TRIANGLES);
    float * faceVertices = new float[15];
    for (int i=0; i<20; i++) // each of the 20 faces
    {
        glColor4fv(c1);
        for (int k=0; k<4; k++) // each of the 4 triangles
        {
            for (int l=0; l<3; l++) faceVertices[9+l] = 0;

            int * vertice = Sphere::faces[i].subTriangles[k]->vertices;

            // don't draw the spikes that face backward
            float ps = 0;
            for (int l=0; l<3; l++) ps += Sphere::verticesCoordonates[3 * vertice[0] + l] * this->n[l];

            if (ps > 0)
            {
                for (int j=0; j<3; j++) // each of the three vertices
                {
                    for (int l=0; l<3; l++) // each of the three coordonates
                    {
                        faceVertices[9+l] += Sphere::verticesCoordonates[3 * vertice[j] + l];
                        faceVertices[3*j+l] = this->radiusInt * Sphere::verticesCoordonates[3 * vertice[j] + l];
                    }
                }

                for (int l=0; l<3; l++) faceVertices[9+l] /= 3;


                for (int t=0; t<3; t++) // for each of the 3 subtriangles
                {
                    // the normal is the vect product of two support vectors, -02-> and -01->
                    for (int j=0; j<3; j++) 
                        faceVertices[12+j] = (faceVertices[9 + ((j+1)%3)] - faceVertices[3*t + (j+1)%3])
                                        * (faceVertices[3*((t+1)%3) + ((j+2)%3)] - faceVertices[3*t + (j+2)%3])
                                        - (faceVertices[9 + ((j+2)%3)] - faceVertices[3*t + (j+2)%3])
                                        * (faceVertices[3*((t+1)%3) + ((j+1)%3)] - faceVertices[3*t + (j+1)%3]);

                    glNormal3fv(faceVertices+12);
                    glVertex3fv(faceVertices+3*t);
                    glVertex3fv(faceVertices+3*((t+1)%3));
                    glVertex3fv(faceVertices+9);
                }
            }
        }
    }
    delete [] faceVertices;
    glEnd();
}

void Mine::drawHelperW(World * w, float * c1, float * c2) // involves no geometric transformation
{
    glLineWidth(2);
    glFrontFace(GL_CCW);
    glDisable(GL_CULL_FACE);

    glBegin(GL_LINES);
    float * faceVertices = new float[15];
    for (int i=0; i<20; i++) // each of the 20 faces
    {
        glColor4fv(c1);
        for (int k=0; k<4; k++) // each of the 4 triangles
        {
            for (int l=0; l<3; l++) faceVertices[9+l] = 0;

            int * vertice = Sphere::faces[i].subTriangles[k]->vertices;

            // don't draw the spikes that face backward
            float ps = 0;
            for (int l=0; l<3; l++) ps += Sphere::verticesCoordonates[3 * vertice[0] + l] * this->n[l];

            if (ps > 0)
            {
                for (int j=0; j<3; j++) // each of the three vertices
                {
                    for (int l=0; l<3; l++) // each of the three coordonates
                    {
                        faceVertices[9+l] += Sphere::verticesCoordonates[3 * vertice[j] + l];
                        faceVertices[3*j+l] = this->radiusInt * Sphere::verticesCoordonates[3 * vertice[j] + l];
                    }
                }

                for (int l=0; l<3; l++) faceVertices[9+l] /= 3;


                for (int t=0; t<3; t++) // for each of the 3 subtriangles
                {
                    // the normal is the vect product of two support vectors, -02-> and -01->
                    for (int j=0; j<3; j++) 
                        faceVertices[12+j] = (faceVertices[9 + ((j+1)%3)] - faceVertices[3*t + (j+1)%3])
                                        * (faceVertices[3*((t+1)%3) + ((j+2)%3)] - faceVertices[3*t + (j+2)%3])
                                        - (faceVertices[9 + ((j+2)%3)] - faceVertices[3*t + (j+2)%3])
                                        * (faceVertices[3*((t+1)%3) + ((j+1)%3)] - faceVertices[3*t + (j+1)%3]);

                    glNormal3fv(faceVertices+12);
                    glVertex3fv(faceVertices+3*t);
                    glVertex3fv(faceVertices+3*((t+1)%3));
                    glVertex3fv(faceVertices+9);
                }
            }
        }
    }
    delete [] faceVertices;
    glEnd();
    glLineWidth(1);
}