#ifndef MAP_H_
#define MAP_H_

#include "Sphere.h"

class Map :
    public Sphere
{
public:
    Map(float r);
    ~Map(void);

    void draw(World * w);
    static void drawNumber(int n, World * w, float x, float y, float h, float width);

private:
    float radius;

    void plotStars(World * w);
    void plotMissiles(World * w);
    void plotSnakes(World * w);
    void plotTunnels(World * w);
    float plotStarPositionIndicators(World * w);
    void drawClock(int t, GLuint * digitTextureId, float Y, World * w);
    void drawHealth(int h, GLuint cylinderTextureId);
};

#endif