#include "World.h"

Map::Map(float r)
{
    this->radius = r;
}

Map::~Map(void)
{
}

#define STAR_INDIC_SIZE 0.3f

float Map::plotStarPositionIndicators(World * w)
{
    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();    
    float Y = 1.4f - ((float)(6*w->width))/w->height;
    glOrtho(-1.3f, -Y + 0.1f, -1.3f, 4.7f, -2, 2);
//    glOrtho(-1.3, 6.7, -1.3, 4.7, -2, 2);
    gluLookAt(0, 0, 1,
        0, 0, 0, 
        1, 0, 0);

    int i;
    for (i=0; i<NUMBER_OF_TARGETS/2; i++)
    {
        if (w->targets[i]->isAlive)
        {
            if (Planet::oppositeTunnels[w->targets[i]->face] == -1)
            {
                glColor3fv(w->planets[w->targets[i]->planet]->color);
            }
            else
            {
                float * c1 = w->planets[w->targets[i]->planet]->color;
                float * c2 = w->planets[World::tunnelConnections[20*w->targets[i]->planet + 
                    w->targets[i]->face]]->color;
                float a = w->targets[i]->colorCoord;
                glColor3f((1-a)*c1[0]+a*c2[0], (1-a)*c1[1]+a*c2[1], (1-a)*c1[2]+a*c2[2]);
            }
            glBindTexture(GL_TEXTURE_2D, w->smallSphereTextureId);
        }
        else
        {
            if (w->targets[i]->autoDestroyed)
            {
                glColor3f(0, 0, 0);
                glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
            }
            else
            {
                glColor3f(0.8f, 0.8f, 0.76f);
                glBindTexture(GL_TEXTURE_2D, w->smileyTextureId);
            }
        }
        glBegin(GL_QUADS);
        glTexCoord2f(1,1);
        glVertex3f(-1.2f + STAR_INDIC_SIZE, Y+STAR_INDIC_SIZE*(i+1), 2);
        glTexCoord2f(1,0);
        glVertex3f(-1.2f + STAR_INDIC_SIZE, Y+STAR_INDIC_SIZE*i, 2);
        glTexCoord2f(0,0);
        glVertex3f(-1.2f, Y+STAR_INDIC_SIZE*i, 2);
        glTexCoord2f(0,1);
        glVertex3f(-1.2f, Y+STAR_INDIC_SIZE*(i+1), 2);
        glEnd();
    }
    for (; i<NUMBER_OF_TARGETS; i++)
    {
        if (w->targets[i]->isAlive)
        {
            if (Planet::oppositeTunnels[w->targets[i]->face] == -1)
            {
                glColor3fv(w->planets[w->targets[i]->planet]->color);
            }
            else
            {
                float * c1 = w->planets[w->targets[i]->planet]->color;
                float * c2 = w->planets[World::tunnelConnections[20*w->targets[i]->planet + 
                    w->targets[i]->face]]->color;
                float a = w->targets[i]->colorCoord;
                glColor3f((1-a)*c1[0]+a*c2[0], (1-a)*c1[1]+a*c2[1], (1-a)*c1[2]+a*c2[2]);
            }
            glBindTexture(GL_TEXTURE_2D, w->smallSphereTextureId);
        }
        else
        {
            if (w->targets[i]->autoDestroyed)
            {
                glColor3f(0, 0, 0);
                glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
            }
            else
            {
                glColor3f(0.8f, 0.8f, 0.76f);
                glBindTexture(GL_TEXTURE_2D, w->smileyTextureId);
            }
        }
        glBegin(GL_QUADS);
        glTexCoord2f(1,1);
        glVertex3f(-1.2f + 2*STAR_INDIC_SIZE, Y+STAR_INDIC_SIZE*(1+i-NUMBER_OF_TARGETS/2), 2);
        glTexCoord2f(1,0);
        glVertex3f(-1.2f + 2*STAR_INDIC_SIZE, Y+STAR_INDIC_SIZE*(i-NUMBER_OF_TARGETS/2), 2);
        glTexCoord2f(0,0);
        glVertex3f(-1.2f + STAR_INDIC_SIZE, Y+STAR_INDIC_SIZE*(i-NUMBER_OF_TARGETS/2), 2);
        glTexCoord2f(0,1);
        glVertex3f(-1.2f + STAR_INDIC_SIZE, Y+STAR_INDIC_SIZE*(1+i-NUMBER_OF_TARGETS/2), 2);
        glEnd();
    }

    //glPopMatrix();
    return Y;
}

void Map::plotStars(World * w)
{
    //glBegin(GL_QUADS);
    //float R = 0.03f;
    //for (int i=0; i<NUMBER_OF_TARGETS; i++)
    //    if (w->targets[i]->isAlive && w->targets[i]->planet == w->currentPlanet)
    //    {
    //        float q[3];
    //        float n=0;
    //        for (int j=0; j<3; j++)
    //        {
    //            q[j] = w->targets[i]->q[j];
    //            n += q[j] * q[j];
    //        }
    //        n = sqrtf(n);
    //        for (int j=0; j<3; j++) q[j] /= n;


    //        glVertex3f(q[0] + R*w->targets[i]->t[0],
    //                   q[1] + R*w->targets[i]->t[1],
    //                   q[2] + R*w->targets[i]->t[2]);
    //        glVertex3f(q[0] + R*w->targets[i]->v[0],
    //                   q[1] + R*w->targets[i]->v[1],
    //                   q[2] + R*w->targets[i]->v[2]);
    //        glVertex3f(q[0] - R*w->targets[i]->t[0],
    //                   q[1] - R*w->targets[i]->t[1],
    //                   q[2] - R*w->targets[i]->t[2]);
    //        glVertex3f(q[0] - R*w->targets[i]->v[0],
    //                   q[1] - R*w->targets[i]->v[1],
    //                   q[2] - R*w->targets[i]->v[2]);
    //    }
    //glEnd();

    //glPolygonOffset(2.0f, -1.0f);
    //glEnable(GL_POLYGON_OFFSET_FILL);

    glColor4f(1, 0.2f, 0, 1);
    glBegin(GL_QUADS);
    for (int i=0; i<NUMBER_OF_TARGETS; i++)
        if (w->targets[i]->isAlive && w->targets[i]->planet == w->currentPlanet)
        {
            float q[3];
            float n=0;
            for (int j=0; j<3; j++)
            {
                q[j] = w->targets[i]->q[j];
                n += q[j] * q[j];
            }
            n = sqrtf(n);
            for (int j=0; j<3; j++) q[j] /= n;

            glVertex3f(q[0] + 0.1f*w->targets[i]->t[0],
                       q[1] + 0.1f*w->targets[i]->t[1],
                       q[2] + 0.1f*w->targets[i]->t[2]);
            glVertex3f(q[0] + 0.1f*w->targets[i]->v[0],
                       q[1] + 0.1f*w->targets[i]->v[1],
                       q[2] + 0.1f*w->targets[i]->v[2]);
            glVertex3f(q[0] - 0.1f*w->targets[i]->t[0],
                       q[1] - 0.1f*w->targets[i]->t[1],
                       q[2] - 0.1f*w->targets[i]->t[2]);
            glVertex3f(q[0] - 0.1f*w->targets[i]->v[0],
                       q[1] - 0.1f*w->targets[i]->v[1],
                       q[2] - 0.1f*w->targets[i]->v[2]);
        }
    glEnd();

    //glDisable(GL_POLYGON_OFFSET_FILL);

    glColor4f(0.5f, 1, 0, 1);
    glPointSize(5);
    glBegin(GL_POINTS);
        for (int i=0; i<NUMBER_OF_MINES; i++)
            if (w->mines[i]->isAlive && w->mines[i]->planet == w->currentPlanet)
                glVertex3fv(w->mines[i]->q);
    glEnd();
}

void Map::plotMissiles(World * w)
{
    glColor4f(1, 1, 0, 1);
    glBegin(GL_TRIANGLES);
    for (int i=0; i<NUMBER_OF_MISSILES; i++)
        if (w->player->missile[i]->isAlive && w->player->missile[i]->planet == w->currentPlanet)
        {
            float q[3];
            float n=0;
            for (int j=0; j<3; j++)
            {
                q[j] = w->player->missile[i]->q[j];
                n += q[j] * q[j];
            }
            n = sqrtf(n);
            for (int j=0; j<3; j++) q[j] /= n;

            glVertex3f(q[0] + 0.1f*w->player->missile[i]->t[0],
                       q[1] + 0.1f*w->player->missile[i]->t[1],
                       q[2] + 0.1f*w->player->missile[i]->t[2]);
            glVertex3f(q[0] - 0.1f*w->player->missile[i]->t[0] + 0.04f*w->player->missile[i]->v[0],
                       q[1] - 0.1f*w->player->missile[i]->t[1] + 0.04f*w->player->missile[i]->v[1],
                       q[2] - 0.1f*w->player->missile[i]->t[2] + 0.04f*w->player->missile[i]->v[2]);
            glVertex3f(q[0] - 0.1f*w->player->missile[i]->t[0] - 0.04f*w->player->missile[i]->v[0],
                       q[1] - 0.1f*w->player->missile[i]->t[1] - 0.04f*w->player->missile[i]->v[1],
                       q[2] - 0.1f*w->player->missile[i]->t[2] - 0.04f*w->player->missile[i]->v[2]);
        }
    glEnd();
}

void Map::plotSnakes(World * w)
{
    glLineWidth(6);
    glColor4f(0.8f, 0.4f, 0.13f, 1);
    glBegin(GL_POINTS);
    float p[3], n;
    for (int s=0; s<NUMBER_OF_SNAKES; s++)
    {
        Snake * snake = w->snakes[s];
        if (snake->planet1 == w->currentPlanet)
        {
            for (int i=0; i<SNAKE_LENGTH; i++)
            {
                if (snake->rings[i].planet == w->currentPlanet)
                {
                    //glNormal3fv(snake->rings[i].n);
                    n=0;
                    for (int j=0; j<3; j++) 
                    {
                        float dd = snake->rings[i].p[j];
                        n += dd * dd;
                    }
                    n = sqrtf(n);

                    glVertex3f(snake->rings[i].p[0] / n,
                                snake->rings[i].p[1] / n,
                                snake->rings[i].p[2] / n);
                }
            }
        }
        else if (snake->planet2 == w->currentPlanet)
        {
            float * tr = snake->tr;
            for (int i=0; i<SNAKE_LENGTH; i++)
            {
                if (snake->rings[i].planet == w->currentPlanet)
                {
                    //glNormal3fv(snake->rings[i].n);
                    n=0;
                    for (int j=0; j<3; j++) 
                    {
                        p[j] = snake->rings[i].p[j] + tr[j];
                        n += p[j] * p[j];
                    }
                    n = sqrtf(n);

                    glVertex3f(p[0] / n,
                               p[1] / n,
                               p[2] / n);
                }
            }
        }
    }
    glEnd();
    glLineWidth(1);
}

void Map::drawNumber(int n, World * w, float x, float y, float dx, float dy)
{
    if (n>0)
    {
        for (int i=0; n>0; i++, n/=10)
        {
            glBindTexture(GL_TEXTURE_2D, w->digitTextureId[n%10]);
            glBegin(GL_QUADS);

            glTexCoord2f(0,0);
            glVertex3f(x-i*dx, y+dy, 2);
            glTexCoord2f(1,0);
            glVertex3f(x+(-i+1)*dx, y+dy, 2);
            glTexCoord2f(1,1);
            glVertex3f(x+(-i+1)*dx, y, 2);
            glTexCoord2f(0,1);
            glVertex3f(x-i*dx, y, 2);
            glEnd();
        }
    }
    else
    {
        glBindTexture(GL_TEXTURE_2D, w->digitTextureId[0]);
        glBegin(GL_QUADS);

        glTexCoord2f(0, 0);
        glVertex3f(x, y+dy, 2);
        glTexCoord2f(1, 0);
        glVertex3f(x+dx, y+dy, 2);
        glTexCoord2f(1, 1);
        glVertex3f(x+dx, y, 2);
        glTexCoord2f(0, 1);
        glVertex3f(x, y, 2);
        glEnd();
    }
}

void Map::drawClock(int msTime, GLuint * digitTextureId, float Y, World * w)
{
    int sTime = 480 - (msTime / 1000);
    if (sTime < 0) 
    {
        sTime = 0;
        w->gameIsOver = 2;
    }
    int min = (sTime/60) % 10;
    int sec = sTime % 60;

    //glMatrixMode(GL_PROJECTION);
    //glPushMatrix();
    //glLoadIdentity();
    //glOrtho(-1.3f, 6.7f, -1.3f, 4.7f, -2, 2);
    //gluLookAt(0, 0, 1,
    //    0, 0, 0, 
    //    1, 0, 0);
    
    // c=1 most of the time; c=0 every TIME_LAPS_BETWEEN_TARGET_AUTODESTROY seconds
    // and 0<c<1 during the couple of seconds around those times
    float c;
    int dt = (msTime-500) % TIME_LAPS_BETWEEN_TARGET_AUTODESTROY;
    if ((dt < 500 || dt > TIME_LAPS_BETWEEN_TARGET_AUTODESTROY-500) && msTime > 2000)
    {
        if (dt > TIME_LAPS_BETWEEN_TARGET_AUTODESTROY-500)
            dt = TIME_LAPS_BETWEEN_TARGET_AUTODESTROY - dt;
        c = ((float)dt)/500;
    }
    else
        c = 1;
    
    glColor3f(c*0.5f + (1-c)*1, c*1 + (1-c)*0.4f, c*0 + (1-c)*0);
    
    glBindTexture(GL_TEXTURE_2D, digitTextureId[sec - 10*(sec/10)]);

    glBegin(GL_QUADS);
    glTexCoord2f(0,0);
    glVertex3f(4.6f, Y+0.22f, 2);
    glTexCoord2f(1,0);
    glVertex3f(4.6f, Y, 2);
    glTexCoord2f(1,1);
    glVertex3f(4.2f, Y, 2);
    glTexCoord2f(0,1);
    glVertex3f(4.2f, Y+0.22f, 2);
    glEnd();

    Y+=0.22f;

    glBindTexture(GL_TEXTURE_2D, digitTextureId[sec/10]);

    glBegin(GL_QUADS);
    glTexCoord2f(0,0);
    glVertex3f(4.6f, Y+0.22f, 2);
    glTexCoord2f(1,0);
    glVertex3f(4.6f, Y, 2);
    glTexCoord2f(1,1);
    glVertex3f(4.2f, Y, 2);
    glTexCoord2f(0,1);
    glVertex3f(4.2f, Y+0.22f, 2);
    glEnd();

    Y+=0.22f;

    glBindTexture(GL_TEXTURE_2D, digitTextureId[10]);

    glBegin(GL_QUADS);
    glTexCoord2f(0,0);
    glVertex3f(4.6f, Y+0.22f, 2);
    glTexCoord2f(1,0);
    glVertex3f(4.6f, Y, 2);
    glTexCoord2f(1,1);
    glVertex3f(4.2f, Y, 2);
    glTexCoord2f(0,1);
    glVertex3f(4.2f, Y+0.22f, 2);
    glEnd();

    Y+=0.22f;

    glBindTexture(GL_TEXTURE_2D, digitTextureId[min - 10*(min/10)]);

    glBegin(GL_QUADS);
    glTexCoord2f(0,0);
    glVertex3f(4.6f, Y+0.22f, 2);
    glTexCoord2f(1,0);
    glVertex3f(4.6f, Y, 2);
    glTexCoord2f(1,1);
    glVertex3f(4.2f, Y, 2);
    glTexCoord2f(0,1);
    glVertex3f(4.2f, Y+0.22f, 2);
    glEnd();

    int logs = 0;
    for (int s = w->score; s>0; s/=10) logs++;
    if (logs == 0) logs = 1;

    float y0 = 1.18f - logs * 0.22f; 
    float y = y0;
    for (int s = w->score; s>0 || y == y0; s /= 10)
    {
        glBindTexture(GL_TEXTURE_2D, digitTextureId[s % 10]);

        glBegin(GL_QUADS);
        glTexCoord2f(0,0);
        glVertex3f(4.6f, y + 0.22f, 2);
        glTexCoord2f(1,0);
        glVertex3f(4.6f, y, 2);
        glTexCoord2f(1,1);
        glVertex3f(4.2f, y, 2);
        glTexCoord2f(0,1);
        glVertex3f(4.2f, y + 0.22f, 2);
        glEnd();

        y += 0.22f;
    }

    //this->drawNumber(w->score, w, 4.2f, 0.1f, 0.4f, 0.22f);
    glPopMatrix();
}

void Map::drawHealth(int h, GLuint cylinderTextureId) // h between 0 (dead) and 100 (healthy)
{
    float z0 = -1.1f + 2*STAR_INDIC_SIZE;
    float z = (h*4.1f - (100-h)*z0)/100;

    glDisable(GL_TEXTURE);
    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();
    glOrtho(-1.3f, 6.7f, -1.3f, 4.7f, -2, 5);
    gluLookAt(0, 0, 3, 0, 0, 0, 1, 0, 0);

    glColor3f(0, 0, 0);
    glBegin(GL_QUADS);
    glVertex3f(4.1f, -6.5f, 2);
    glVertex3f(4.1f, -6.6f, 2);
    glVertex3f(z, -6.6f, 2);
    glVertex3f(z, -6.5f, 2);
    glEnd();

    glBindTexture(GL_TEXTURE_2D, cylinderTextureId);
    glBegin(GL_QUADS);
    glColor3f(((float) (100-h))/100, ((float) h)/100, 0);
    glTexCoord2f(0, 1);
    glVertex3f(z, -6.5f, 2);
    glTexCoord2f(1, 1);
    glVertex3f(z, -6.6f, 2);
    glColor3f(1, 0, 0);
    glTexCoord2f(1, 0);
    glVertex3f(z0, -6.6f, 2);
    glTexCoord2f(0, 0);
    glVertex3f(z0, -6.5f, 2);
    glEnd();

    glEnable(GL_TEXTURE);

    glPopMatrix();
}

void Map::plotTunnels(World * w)
{
    for (int i=0; i<20; i++) // i: currentFace
        // draw the tunnel in the middle of the middle triangle
        if (Planet::oppositeTunnels[i] != -1)
        {
            //glEnable(GL_BLEND);
            float * cl = w->planets[w->tunnelConnections[20 * w->currentPlanet + i]]->color;
            glColor4f(cl[0], cl[1], cl[2], 1);
            glBegin(GL_TRIANGLE_FAN);
            int * vertice = Sphere::faces[i].subTriangles[3]->vertices;

            float * v0 = Sphere::verticesCoordonates + 3 * vertice[0];
            float * v1 = Sphere::verticesCoordonates + 3 * vertice[1];
            float * v2 = Sphere::verticesCoordonates + 3 * vertice[2];
            // isobarycentre
            glVertex3f((v0[0]+v1[0]+v2[0])*0.333f, (v0[1]+v1[1]+v2[1])*0.333f, (v0[2]+v1[2]+v2[2])*0.333f);

            glColor4f(cl[0] * 0.1f, cl[1] * 0.1f, cl[2] * 0.1f, 1);
            for (int j=0; j<3; j++)
            {
                float * v1 = Sphere::verticesCoordonates + 3 * vertice[j];
                float * v2 = Sphere::verticesCoordonates + 3 * vertice[(j+1)%3];

                glVertex3f((2*v1[0]+v2[0])*0.333f, (2*v1[1]+v2[1])*0.333f, (2*v1[2]+v2[2])*0.333f);
                glVertex3f((v1[0]+2*v2[0])*0.333f, (v1[1]+2*v2[1])*0.333f, (v1[2]+2*v2[2])*0.333f);
            }
            glVertex3f((2*v0[0]+v1[0])/3, (2*v0[1]+v1[1])/3, (2*v0[2]+v1[2])/3);
            glEnd();
            //glDisable(GL_BLEND);
        }
}

void Map::draw(World * w)
{
    glDisable(GL_LIGHTING);

    glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);

    float pos[4] = {0, 0, 0, 1};
    //glLightfv(GL_LIGHT3, GL_POSITION, pos);

    if (w->radar_on)
    {
        glDisable(GL_DEPTH_TEST);
        //glDisable(GL_LIGHTING);
        //glDisable(GL_LIGHT0);
        //glEnable(GL_LIGHT3);
        //glDisable(GL_LIGHT2);

        glMatrixMode(GL_PROJECTION);
        glPushMatrix();
        glLoadIdentity();
        //gluPerspective(45, 4.0/3, 0.1, 100);
        glOrtho(-1.1f, -1.1f + ((float)(6*w->width))/w->height, -1.1f, 4.9f, -20, 20);

        gluLookAt(w->p[0], w->p[1], w->p[2],
            0, 0, 0, 
            w->mapTop[0], w->mapTop[1], w->mapTop[2]);
        //gluLookAt(0, 0, 1,
        //    0, 0, 0, 
        //    0, 1, 0);

        glMatrixMode(GL_MODELVIEW);
        glPushMatrix();
        glNormal3fv(w->p);
        glScalef(1.07f, 1.07f, 1.07f);
        glColor3f(0.1f, 0.1f, 0.1f);
        glBegin(GL_TRIANGLES);
        for (int i=0; i<20; i++)
        {
            for (int k=0; k<4; k++)
            {
                int * vertice = Sphere::faces[i].subTriangles[k]->vertices;
                for (int j=0; j<3; j++)
                    glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[j]);
            }
        }
        glEnd();
        glPopMatrix();

        glEnable(GL_DEPTH_TEST);

        this->plotTunnels(w);

        glPolygonOffset(1.0f, -1.0f);
        glEnable(GL_POLYGON_OFFSET_LINE);
        for (int i=0; i<20; i++) // i: currentFace
        {
            glColor4f(0.8f, 1, 0, 1);
            for (int k=0; k<3; k++) // useless to draw the middle triangle
            {
                glBegin(GL_LINE_LOOP);
                int * vertice = Sphere::faces[i].subTriangles[k]->vertices;
                for (int j=0; j<3; j++)
                    glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[j]);
                glEnd();
            }
        }
        glDisable(GL_POLYGON_OFFSET_LINE);

        this->plotStars(w);
        this->plotMissiles(w);
        this->plotSnakes(w);
        //glDisable(GL_POLYGON_OFFSET_FILL);
        //glDisable(GL_POLYGON_OFFSET_POINT);

        glEnable(GL_BLEND);
        glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

        glPushMatrix();
        glScalef(0.99f, 0.99f, 0.99f);
        glColor4f(0.1f, 0.1f, 0.1f, 0.6f);
        glBegin(GL_TRIANGLES);
        for (int i=0; i<20; i++)
        {
            for (int k=0; k<4; k++)
            {
                int * vertice = Sphere::faces[i].subTriangles[k]->vertices;
                for (int j=0; j<3; j++)
                    glVertex3fv(Sphere::verticesCoordonates + 3 * vertice[j]);
            }
        }
        glEnd();
        glPopMatrix();

        glDisable(GL_BLEND);

        glMatrixMode(GL_PROJECTION);
        glPushMatrix();
        glLoadIdentity();
        glOrtho(-1.1f, -1.1f + ((float)(6*w->width))/w->height, -1.1f, 4.9f, -2, 2);

        gluLookAt(0, 0, 1,
            0, 0, 0, 
            1, 1, 0);

        glColor4f(1, 1, 1, 1);
        glBegin(GL_QUADS);
        glVertex3f(-0.05f, -0.05f, 2);
        glVertex3f( 0.05f, -0.05f, 2);
        glVertex3f( 0.05f,  0.05f, 2);
        glVertex3f(-0.05f,  0.05f, 2);
        glEnd();

        glBindTexture(GL_TEXTURE_2D, w->whiteTextureId);
        this->drawHealth(w->player->health, w->cylinderTextureId);

        float Y = this->plotStarPositionIndicators(w);

        if (w->timeOffset == 1)
            this->drawClock(0, w->digitTextureId, Y, w);
        else
        {
            this->drawClock((int)(SDL_GetTicks() - w->timeOffset), w->digitTextureId, Y, w);
        }
        
        glPopMatrix();
        glMatrixMode(GL_PROJECTION);
        glPopMatrix();
        glMatrixMode(GL_MODELVIEW);

        //glEnable(GL_LIGHT0);
        //glDisable(GL_LIGHT3);
        //glEnable(GL_LIGHT2);
    }
    glEnable(GL_LIGHTING);
}
