#include "World.h"
#include "Tunnel.h"
//#include "Player.h"
//#include "Target.h"
//#include "ExploMine.h"

#ifdef _WIN32
#undef main
#endif


int main(int argc, char **argv) 
{
    World * w = new World(22);
    int n = Sphere::init(w);

    w->planets[0] = new Planet(0, 0, 0, 0, 0.6f, 0.6f, 0);
    w->planets[1] = new Planet(1, 1, 2, -1, 0, 0.95f, 0.0f);
    w->planets[2] = new Planet(2, 3, 2.5f, 2.2f, 0, 0, 0.95f);
    w->planets[3] = new Planet(3, 2, -1, -0.5f, 0.95f, 0.0f, 0.0f);
    w->planets[4] = new Planet(4, -3, -1.5f, 2.2f, 0, 0.6f, 0.6f);
    w->planets[5] = new Planet(5, -2, 0, -2, 0.6f, 0, 0.6f);
    for (int i=0; i<NUMBER_OF_PLANETS; i++) w->addSphere(w->planets[i]);
    w->currentPlanet = 0;

    //Planet::digTunnels(0.34f, 0.098f, w, n);
    Planet::connectTunnels(w);

    w->targets = new Target*[NUMBER_OF_TARGETS];

    w->targets[0] = new Target( 0.1f,  1,  -0.3f, 1, 0, 0.5f, 3, w);
    w->targets[1] = new Target( 0, -1,  0, 1, 0, 0, 0, w);
    w->targets[2] = new Target( 1,  1.3f,  0, 0, 1, 0, 2, w);
    w->targets[3] = new Target( -0.1f,  1,  -0.3f, 1, 0.3f, 0.5f, 1, w);
    w->targets[4] = new Target( 0.7f, -1,  0.1f, 1, -0.3f, 1, 4, w);
    w->targets[5] = new Target( 0.9f,  0.3f,  -0.1f, 0.7f, 0.3f, -0.4f, 5, w);
    w->targets[6] = new Target( 0.2f,  -0.5f,  -0.8f, 0.8f, 0.1f, 0.1f, 0, w);
    w->targets[7] = new Target( -0.3f,  0.5f,  0.2f, 0.5f, 0.2f, 0.9f, 2, w);
    w->targets[8] = new Target( 0.3f,  0.9f,  0.2f, 1, 0.2f, 1, 5, w);
    w->targets[9] = new Target(-1,  1.2f,  1, 0.6f, 1.2f, 0.2f, 1, w);
    w->targets[10] = new Target( 0.6f, -1,  0.7f, 1, -0.5f, -0.3f, 4, w);
    w->targets[11] = new Target( 0.4f,  -0.5f, -0.39f, 0.9f, -0.2f, 0.1f, 0, w);
    w->targets[12] = new Target( 0.75f,  0.2f,  0.4f, 0.1f, 1.2f, 1, 4, w);
    w->targets[13] = new Target( 0.1f,  1,  -0.3f, 1, 0.1f, 0.5f, 2, w);
    w->targets[14] = new Target( 0, -1,  0, 1, 1, 0, 1, w);
    w->targets[15] = new Target( -1,  -1.3f,  0, 0, 1, 0.2f, 3, w);
    w->targets[16] = new Target( 0.1f,  -1,  0.3f, 1, -0.3f, 0.5f, 4, w);
    w->targets[17] = new Target( -0.7f, 1,  -0.1f, -1, -0.3f, 1, 5, w);
    w->targets[18] = new Target( 0.9f,  0.3f,  -0.1f, -0.7f, 0.3f, -0.4f, 1, w);
    w->targets[19] = new Target( 0.2f,  -0.5f,  -0.8f, -0.8f, 0.1f, 0.1f, 2, w);
    w->targets[20] = new Target( -0.3f,  0.5f,  0.2f, 0.5f, -0.2f, 0.9f, 3, w);
    w->targets[21] = new Target( 0.3f,  0.9f,  0.2f, 1, -0.2f, 1, 4, w);
    w->targets[22] = new Target(-1,  1.2f,  1, 0.6f, -1.2f, -0.2f, 5, w);
    w->targets[23] = new Target( 0.6f, -1,  0.7f, 1, 0.5f, -0.3f, 1, w);
    w->targets[24] = new Target( 0.4f,  -0.5f, -0.39f, -0.9f, -0.2f, 0.1f, 4, w);
    w->targets[25] = new Target( 0.75f,  0.2f,  0.4f, 0.1f, -1.2f, 1, 5, w);

    //for (int i=0; i<NUMBER_OF_TARGETS; i++) w->addSphere(w->targets[i]);

    w->snakes[0] = new Snake(w, 1, 0, 0, 0, -1.5f, 1, /*planet*/ 1);
    w->snakes[1] = new Snake(w, 0.7f, -0.7f, 0, 0, -1, 1, /*planet*/ 2);
    w->snakes[2] = new Snake(w, 0.7f, 0.7f, 0, 0, -0.7f, 0.4f, /*planet*/ 3);
    w->snakes[3] = new Snake(w, 1, 0.5f, 0, 0, 0.2f, 1, /*planet*/ 4);
    w->snakes[4] = new Snake(w, -1, 0.5f, 0, 0, 1.5f, 1, /*planet*/ 5);

    w->snakes[5] = new Snake(w, 1, 0, 0, 0, -1.5f, 1, /*planet*/ 2);
    w->snakes[6] = new Snake(w, 1, 0, 0, 0, -1, 1, /*planet*/ 3);
    w->snakes[7] = new Snake(w, 1, 0, 0, 0, -0.7f, 0.4f, /*planet*/ 4);
    w->snakes[8] = new Snake(w, 1, 0.5f, 0, 0, 0.2f, 1, /*planet*/ 5);
    w->snakes[9] = new Snake(w, -1, 0.5f, 0, 0, 1.5f, 1, /*planet*/ 1);

    w->snakes[10] = new Snake(w, 1, 0, 0, 0, -1.5f, 1, /*planet*/ 3);
    w->snakes[11] = new Snake(w, -0.7f, 0.7f, 0, 0, -1, 1, /*planet*/ 4);
    w->snakes[12] = new Snake(w, 1, 0, 0, 0, -0.7f, 0.4f, /*planet*/ 5);
    w->snakes[13] = new Snake(w, 1, 0.5f, 0, 0, 0.2f, 1, /*planet*/ 1);
    w->snakes[14] = new Snake(w, -1, 0.5f, 0, 0, 1.5f, 1, /*planet*/ 2);

    w->player = new Player(0.014f, 0.68927294f, 0.00923f,  -0.72444314f,
        -0.46188408f, -0.764781f, -0.449f, 2, w);
    w->addSphere(w->player);

    Map * map = new Map(0.1f);
    w->addSphere(map);
    w->addSphere(new Sky());

    w->update();
    w->update();
    w->draw();
    w->draw();
    w->drawWelcomeScreen();
    SDL_GL_SwapBuffers();
    w->draw();
    w->drawWelcomeScreen();
    SDL_GL_SwapBuffers();
    
    w->loadAllSounds();

    //Sphere::loadTexture("Textures/smiley.bmp", &map->smileyTextureId);
    //Sphere::loadTexture("Textures/fire.bmp", &w->fireTextureId);
    //Sphere::loadTexture("Textures/smoke.bmp", &w->smokeTextureId);
    //Sphere::loadTexture("Textures/pause.bmp", &w->pauseTextureId);
    w->loadAdditionalTextures();

    //w->initSound();

    w->pauseGame = true;

    Uint32 time, oldTime;
    time = SDL_GetTicks();
    while (w->handleEvents()) 
    {
        if (!w->pauseGame)
        {
            oldTime = time;
            w->update();
    	    w->draw();
            SDL_GL_SwapBuffers();
            time = SDL_GetTicks();

            Uint32 dtime = (time - oldTime);
            if (dtime < 35) SDL_Delay(35-dtime);
        }
        else
        {
            oldTime = time;
            
            SDL_GL_SwapBuffers();
            time = SDL_GetTicks();

            Uint32 dtime = (time - oldTime);
            if (dtime < 35) SDL_Delay(35-dtime);

            if (w->die) break;
        }
    }

    //delete w;
    SDL_CloseAudio();
    exit(0);
}
