uniform float time;	//passed as frame counter from game
uniform float inside;

varying float fogdist;
varying vec3 lightDir;
varying vec3 normal;

void main()
{
	//Color calculations
	//gl_Position is vec4
	vec4 v = gl_Vertex;
//	v.z = v.z + cos(2.5*v.y+ time*.5)*.1;
	gl_Position = gl_ModelViewProjectionMatrix * v;	//default transformation

	vec4 ecpos4 = gl_ModelViewMatrix * gl_Vertex;
	
	//normal
	normal = gl_NormalMatrix * gl_Normal;

	//fog
	lightDir =vec3( gl_LightSource[0].position - ecpos4);
	fogdist = length(lightDir);

	//color for lighting
	//pass on the dot product as color for intensity calculations
	float NdotL = dot(normalize(-gl_LightSource[0].spotDirection),normalize(lightDir));
	NdotL = pow(NdotL,21);
	gl_FrontColor = vec4(NdotL,NdotL,NdotL,1);
	
	//textures
	if(inside>0)
	gl_TexCoord[0] = vec4(gl_MultiTexCoord0.x,gl_MultiTexCoord0.y,0,1);
	else
	gl_TexCoord[0] = vec4(gl_MultiTexCoord0.x,4*gl_MultiTexCoord0.y,0,1) + vec4(0.007*(1+sin(1.4*time+gl_Vertex.z/2)),0.003*(1+sin(0.95*time)),0,1);
}
