//uniform float time;
uniform float inside;
uniform sampler2D _handle;

varying float fogdist;
varying vec3 lightDir;
varying vec3 normal;

void main()
{	
	vec3 color = vec3(0.2,0.0,0.0);
	vec3 specular = vec3(0.9,0.9,1.0);
	
//	float NdotL = dot( normalize(normal), normalize(lightDir) );
	float att,spotEffect;

	vec3 diffuse = vec3( 0.4, 0.05, 0.0 );

	
	diffuse = diffuse * dot( normalize(gl_LightSource[0].spotDirection.xyz), normalize(-lightDir) );
	spotEffect = dot( normalize(gl_LightSource[0].spotDirection.xyz), normalize(normal) );

	
	att = spotEffect / (gl_LightSource[0].constantAttenuation +
			gl_LightSource[0].linearAttenuation * fogdist +
			gl_LightSource[0].quadraticAttenuation * fogdist * fogdist);

	color += att * diffuse;
//	color += att * att * abs(pow(spotEffect,51)) * specular;	//beam of light

	if (spotEffect > 0.0) {
			color += pow (att,6) * specular * spotEffect;
	}

	vec4 fogColor = vec4( 0.5, 0.0, 0.0, 1.0 );
	
	float fog,fogMult;
	// -0.012 for vein, and -0.005 for world
	fogMult = -1*mix(.011,.005,inside);	
	fog = pow(2.5,fogdist*fogMult);
	//fog = clamp(fog, 0.0, 1.0);
	

	vec4 texcolor = texture2D(_handle,gl_TexCoord[0].st);
	vec4 wallColor = texcolor;
	wallColor += texcolor.r*texcolor.r*texcolor.r*vec4(0.2+0.4*color.r,color.g,color.b,0);
	
	gl_FragColor = mix(fogColor,wallColor,fog);
}
