uniform float time;	//passed as frame counter from game

varying vec3 normal;
varying vec3 lightDir;
//varying float dist;

void main()
{
	//light
	vec3 ecpos3 = vec3(gl_ModelViewMatrix * gl_Vertex);
	lightDir = gl_LightSource[0].position.xyz - ecpos3;

	//Color calculations
//	dist = length(lightDir);
	
	//normal
	//NOT normalizing...just for experimentation
	normal = gl_NormalMatrix * gl_Normal;	
	
	//textures
	gl_TexCoord[0] = gl_MultiTexCoord0;

	//gl_Position is vec4
	vec4 v = gl_Vertex;
	
	float temp = mod(abs(v.x),0.5);
	if(length(temp)<0.12)// && length(temp)>0.1045)		
//	if( mod(abs(v.x),0.2)>0.1 && mod(abs(v.y),0.2)>0.1 && mod(abs(v.z),0.2) > 0.1)
	{
		float val = 1.6*(1-3*length(temp));
		val = (0.6+0.2*(1+cos(time*1.5+v.z)))*val;
		//val = clamp(val,1,2);
		v = vec4(v.xyz*val,v.w);
		gl_FrontColor = vec4(1);
	}
	else 
		gl_FrontColor = vec4(0.3+0.1*(1+sin(1.5*time)),1,1,1);
//	}
		
	v.x = v.x + cos(2.5*v.y+ time*3.5)*.3;
	
	gl_Position = gl_ModelViewProjectionMatrix * v;	//default transformation


}
