varying vec3 normal;
varying vec3 lightDir;
//varying float dist;

uniform float fire;
uniform float hit;
uniform float time;
uniform sampler2D textureId ;

void main()
{	
	vec4 color = vec4(0.0);

	vec4 specular = vec4(.05,0.58,0.8,1);
	vec4 diffuse  = vec4(0.3,0.58,0.48,1);
	vec4 ambient  = vec4(0.0,0.25,0.0,1);

	float att,spotEffect,NdotHV;
	float dist = length(lightDir);
	vec3 n = normalize(normal);
	vec3 lightdir = lightDir/dist;

	float NdotL  = dot(n,lightdir);
	vec3 spotDir = normalize(-gl_LightSource[0].spotDirection.xyz);

	spotEffect = dot(spotDir,n);// normalize(lightDir));
	att = spotEffect / (gl_LightSource[0].constantAttenuation +
			gl_LightSource[0].linearAttenuation * dist +
			gl_LightSource[0].quadraticAttenuation * dist * dist);

	if(gl_Color.r >0.55)	//for spikes seperate coloring
		color = diffuse;
	else
	{
		color =  (diffuse * NdotL + ambient);
		NdotHV = max(dot(lightdir,spotDir),0.0);
		color += att * specular * pow(NdotHV,50);//gl_FrontMaterial.shininess);
		color *= gl_Color;
	}

	vec4 fogColor = vec4( 0.5, 0, 0, 1 );	
	float fog = pow(2.5,dist*-.006);
	color = mix(fogColor,color,fog);
                 
	gl_FragColor = color;	
	if(fire > 0)
		gl_FragColor += vec4(0.0,0.2,0.1,1);
	else if (hit>0)
		gl_FragColor += vec4(0.3,-0.4,-0.3,1);
}
