varying vec3 normal;
varying vec3 lightDir;
//varying float dist;

uniform float fire;
uniform float hit;
uniform float time;
uniform sampler2D textureId ;

void main()
{	
	vec4 color = vec4(0.0);
//	vec4 specular = vec4(.98,0.58,0.4,1);
//	vec4 diffuse  = vec4(0.6,0.24,0.04,1);
//	vec4 ambient  = vec4(0.1,0.1,0.0,1);

	vec4 specular = vec4(.05,0.8,0.68,1);
	vec4 diffuse  = vec4(0.3,0.48,0.68,1);
	vec4 ambient  = vec4(0.0,0.0,0.25,1);

	float att,spotEffect,NdotHV;
	float dist = length(lightDir);
	vec3 n = normalize(normal);
	vec3 lightdir = normalize(lightDir);

	float NdotL = max(dot(n,lightdir),0.0);
	vec3 spotDir  = normalize(-gl_LightSource[0].spotDirection.xyz);

	spotEffect = dot(spotDir,n);// normalize(lightDir));
	att = spotEffect / (gl_LightSource[0].constantAttenuation +
			gl_LightSource[0].linearAttenuation * dist +
			gl_LightSource[0].quadraticAttenuation * dist * dist);

	color =  (diffuse * NdotL + ambient);
	if(gl_Color.r >0.55)
		color = diffuse;
	else
	{
		NdotHV = max(dot(lightdir,spotDir),0.0);
		color += att * specular * pow(NdotHV,50);//gl_FrontMaterial.shininess);
	}
		
	//color.b *= 0.6+0.2*(1+sin(time));
	color *= gl_Color;

        float fog;
        // -0.012 for vein, and -0.005 for world
	vec4 fogColor = vec4( 0.5, 0, 0, 1 );	
	fog = pow(2.5,dist*-.006);
	color = mix(fogColor,color,fog);
                 
	gl_FragColor = color;	
	if(fire > 0)
		gl_FragColor += vec4(0.0,0.1,0.2,1);
	else if (hit>0)
		gl_FragColor += vec4(0.3,-0.2,-0.4,1);
}
